/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.license.util;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.stardog.license.util.JSONMethods;
import com.stardog.license.util.LicensePrompt;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LicenseFlow {
    private Map<String, String> mVariables = new HashMap<String, String>();
    private List<LicensePrompt> mPrompts = new ArrayList<LicensePrompt>();
    private byte[] mLicense;
    private String mMessage;
    private String mError;
    private boolean mTerminated = false;

    public LicenseFlow prompt(LicensePrompt thePrompt) {
        this.mPrompts.add(thePrompt);
        return this;
    }

    public LicenseFlow prompts(List<LicensePrompt> thePrompts) {
        this.mPrompts = thePrompts;
        return this;
    }

    public Collection<LicensePrompt> prompts() {
        return this.mPrompts;
    }

    public LicenseFlow variable(String theKey, String theValue) {
        this.mVariables.put(theKey, theValue);
        return this;
    }

    public String variable(String theKey) {
        return this.mVariables.get(theKey);
    }

    public LicenseFlow variables(Map<String, Object> theVariables) {
        this.mVariables = new HashMap<String, String>();
        for (Map.Entry<String, Object> e : theVariables.entrySet()) {
            this.mVariables.put(e.getKey().toString(), e.getValue() != null ? e.getValue().toString() : "");
        }
        return this;
    }

    public Map<String, String> variables() {
        return this.mVariables;
    }

    public LicenseFlow license(byte[] theBytes) {
        this.mLicense = theBytes;
        return this;
    }

    public byte[] license() {
        return this.mLicense;
    }

    public boolean hasLicense() {
        return this.mLicense != null;
    }

    public LicenseFlow message(String theMessage) {
        this.mMessage = theMessage;
        return this;
    }

    public String message() {
        return this.convertVariables(Optional.ofNullable(this.mMessage).orElse(""));
    }

    public LicenseFlow error(String theError) {
        this.mError = theError;
        return this;
    }

    public String error() {
        return this.convertVariables(this.mError);
    }

    public boolean hasError() {
        return !Strings.isNullOrEmpty((String)this.mError);
    }

    public LicenseFlow terminated(boolean theTerminated) {
        this.mTerminated = theTerminated;
        return this;
    }

    public boolean terminated() {
        return this.mTerminated;
    }

    public String getVariablesAsJson() {
        JSONObject aVariables = new JSONObject();
        for (String k : this.mVariables.keySet()) {
            try {
                aVariables.put(k, (Object)this.mVariables.get(k));
            }
            catch (JSONException jSONException) {}
        }
        return aVariables.toString();
    }

    @Nonnull
    public static LicenseFlow fromJson(String theJson) {
        try {
            JSONObject aJSONObject = new JSONObject(theJson);
            JSONObject aVariables = aJSONObject.getJSONObject("variables");
            if (aJSONObject.has("error")) {
                return new LicenseFlow().error(aJSONObject.getString("error"));
            }
            if (aJSONObject.has("license")) {
                return new LicenseFlow().variables(JSONMethods.toMap(aVariables)).license(Base64.getDecoder().decode(aJSONObject.getString("license"))).message(aJSONObject.getString("message"));
            }
            JSONArray aPrompts = aJSONObject.getJSONArray("prompts");
            boolean aTerminated = aJSONObject.getBoolean("terminated");
            ArrayList aJSONObjects = Lists.newArrayList();
            for (Object o : JSONMethods.toList(aPrompts)) {
                aJSONObjects.add(new JSONObject(o.toString()));
            }
            return new LicenseFlow().terminated(aTerminated).variables(JSONMethods.toMap(aVariables)).prompts(aJSONObjects.stream().map(LicensePrompt::fromJson).collect(Collectors.toList()));
        }
        catch (JSONException e) {
            return new LicenseFlow().error(e.getMessage());
        }
    }

    public String toJson() throws JSONException {
        JSONObject aJson = new JSONObject();
        JSONObject aVariables = new JSONObject();
        for (String k : this.mVariables.keySet()) {
            aVariables.put(k, (Object)this.mVariables.get(k));
        }
        aJson.put("variables", (Object)aVariables);
        if (this.mError != null) {
            aJson.put("error", (Object)this.mError);
        } else if (this.mLicense != null) {
            aJson.put("license", (Object)Base64.getEncoder().encodeToString(this.mLicense));
            aJson.put("message", (Object)(this.mMessage == null ? "" : this.mMessage));
        } else {
            for (String k : this.mVariables.keySet()) {
                aVariables.put(k, (Object)this.mVariables.get(k));
            }
            JSONArray aPrompts = new JSONArray();
            for (LicensePrompt p : this.mPrompts) {
                aPrompts.put((Object)p.toJson());
            }
            aJson.put("prompts", (Object)aPrompts);
            aJson.put("terminated", this.mTerminated);
        }
        return aJson.toString();
    }

    String convertVariables(String theString) {
        Pattern aRegex = Pattern.compile("\\{([a-zA-Z0-9_]+)\\}");
        Matcher aMatcher = aRegex.matcher(theString);
        String aNewString = theString;
        while (aMatcher.find()) {
            aNewString = aNewString.replace(aMatcher.group(), this.mVariables.containsKey(aMatcher.group(1)) ? (CharSequence)this.mVariables.get(aMatcher.group(1)) : aMatcher.group());
        }
        return aNewString;
    }

    public List<LicensePrompt> getPrompts() {
        return this.mPrompts;
    }

    public boolean isTerminated() {
        return this.mTerminated;
    }

    public LicenseFlow setVariable(String theKey, String theValue) {
        return this.variable(theKey, theValue);
    }
}

