/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.license.util;

import com.stardog.license.util.LicenseFlow;
import java.io.Serializable;

public class Condition
implements Serializable {
    private static final long serialVersionUID = 42L;
    private final String mOperator;
    private final String mFirst;
    private final String mSecond;

    public Condition(String theOperator, String theFirst, String theSecond) {
        this.mOperator = theOperator;
        this.mFirst = theFirst;
        this.mSecond = theSecond;
    }

    public boolean test(LicenseFlow theLicenseFlow) {
        String aFirst = theLicenseFlow.convertVariables(this.mFirst);
        String aSecond = theLicenseFlow.convertVariables(this.mSecond);
        switch (this.mOperator) {
            case "=": {
                return aFirst.equalsIgnoreCase(aSecond);
            }
            case "!=": {
                return !aFirst.equalsIgnoreCase(aSecond);
            }
            case "startsWith": {
                return aFirst.trim().toUpperCase().startsWith(aSecond.trim().toUpperCase());
            }
            case "notStartsWith": {
                return !aFirst.trim().toUpperCase().startsWith(aSecond.trim().toUpperCase());
            }
            case "endsWith": {
                return aFirst.trim().toUpperCase().endsWith(aSecond.trim().toUpperCase());
            }
            case "notEndsWith": {
                return !aFirst.trim().toUpperCase().endsWith(aSecond.trim().toUpperCase());
            }
            case ">": {
                try {
                    return Double.compare(Double.parseDouble(aFirst), Double.parseDouble(aSecond)) > 0;
                }
                catch (NumberFormatException e) {
                    return aFirst.compareTo(aSecond) > 0;
                }
            }
            case ">=": {
                try {
                    return Double.compare(Double.parseDouble(aFirst), Double.parseDouble(aSecond)) >= 0;
                }
                catch (NumberFormatException e) {
                    return aFirst.compareTo(aSecond) >= 0;
                }
            }
            case "<": {
                try {
                    return Double.compare(Double.parseDouble(aFirst), Double.parseDouble(aSecond)) < 0;
                }
                catch (NumberFormatException e) {
                    return aFirst.compareTo(aSecond) < 0;
                }
            }
            case "<=": {
                try {
                    return Double.compare(Double.parseDouble(aFirst), Double.parseDouble(aSecond)) <= 0;
                }
                catch (NumberFormatException e) {
                    return aFirst.compareTo(aSecond) <= 0;
                }
            }
        }
        return false;
    }
}

