/*
 * Decompiled with CFR 0.152.
 */
package com.stardog;

import com.stardog.ErrorCode;
import com.stardog.ErrorParser;
import java.util.Optional;

public abstract class SkeletonErrorParser
implements ErrorParser {
    @Override
    public Optional<ErrorCode> parse(Throwable t) {
        ErrorCode[] codes;
        ErrorCode ec = null;
        for (ErrorCode pec : codes = this.getErrorCodes()) {
            if (!this.codeMatches(pec, t)) continue;
            ec = pec;
            break;
        }
        return Optional.ofNullable(ec);
    }

    @Override
    public Optional<Throwable> errorFor(ErrorCode ec, String errorMsg) {
        String errorCode;
        Throwable t = null;
        if (ec != null && this.canBeParsed(errorCode = ec.getFormattedString())) {
            for (ErrorCode pec : this.getErrorCodes()) {
                if (!pec.getFormattedString().equals(errorCode)) continue;
                t = this.toThrowable(pec, errorMsg);
                break;
            }
        }
        return Optional.ofNullable(t);
    }

    @Override
    public Optional<ErrorCode> parseCode(String formattedCode) {
        ErrorCode ec = null;
        if (formattedCode != null && this.canBeParsed(formattedCode)) {
            for (ErrorCode pec : this.getErrorCodes()) {
                if (!pec.getFormattedString().equals(formattedCode)) continue;
                ec = pec;
                break;
            }
        }
        return Optional.ofNullable(ec);
    }

    protected abstract Throwable toThrowable(ErrorCode var1, String var2);

    protected abstract boolean canBeParsed(String var1);

    protected abstract ErrorCode[] getErrorCodes();

    protected abstract boolean codeMatches(ErrorCode var1, Throwable var2);
}

