/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.index;

import com.complexible.stardog.index.MutableUnaryCount;
import com.complexible.stardog.index.UnaryCount;
import com.google.common.primitives.Longs;

public final class UnaryCounts {
    public static MutableUnaryCount mutable(long theX, long theCount, long theContext) {
        return new MutableUnaryCountImpl(theX, theCount, theContext);
    }

    public static MutableUnaryCount mutable(long theX, long theCount) {
        return new MutableUnaryCountImpl(theX, theCount, -1L);
    }

    public static UnaryCount create(long theX, long theCount) {
        return new LongNoContextUnaryCountImpl(theX, theCount);
    }

    public static UnaryCount create(long theX, long theCount, long theContext) {
        if (theContext == -1L) {
            return UnaryCounts.create(theX, theCount);
        }
        return new LongUnaryCountImpl(theX, theCount, theContext);
    }

    private static class MutableUnaryCountImpl
    extends AbstractUnaryCountImpl
    implements MutableUnaryCount {
        private long mX;
        private long mCount;
        private long mContext;

        MutableUnaryCountImpl(long theX, long theCount, long theContext) {
            this.mX = theX;
            this.mCount = theCount;
            this.mContext = theContext;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public void setX(long theX) {
            this.mX = theX;
        }

        @Override
        public final long getCount() {
            return this.mCount;
        }

        @Override
        public void setCount(long theZ) {
            this.mCount = theZ;
        }

        @Override
        public final long getContext() {
            return this.mContext;
        }

        @Override
        public void setContext(long theContext) {
            this.mContext = theContext;
        }

        @Override
        public int compareTo(UnaryCount o) {
            if (o == null) {
                return 1;
            }
            int comp = Longs.compare((long)this.getX(), (long)o.getX());
            if (comp == 0 && (comp = Longs.compare((long)this.getCount(), (long)o.getCount())) == 0) {
                comp = Longs.compare((long)this.getContext(), (long)o.getContext());
            }
            return comp;
        }

        @Override
        public MutableUnaryCountImpl copy() {
            return new MutableUnaryCountImpl(this.mX, this.mCount, this.mContext);
        }

        @Override
        public String toString() {
            return "(" + this.getX() + "){" + this.getContext() + "}=" + this.getCount();
        }
    }

    private static class LongNoContextUnaryCountImpl
    extends AbstractUnaryCountImpl {
        private final long mX;
        private final long mCount;

        private LongNoContextUnaryCountImpl(long theX, long theCount) {
            this.mX = theX;
            this.mCount = theCount;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public final long getCount() {
            return this.mCount;
        }

        @Override
        public long getContext() {
            return -1L;
        }

        @Override
        public UnaryCount copy() {
            return new LongNoContextUnaryCountImpl(this.mX, this.mCount);
        }
    }

    private static class LongUnaryCountImpl
    extends AbstractUnaryCountImpl {
        private final long mX;
        private final long mCount;
        private final long mContext;

        private LongUnaryCountImpl(long theX, long theCount, long theContext) {
            this.mX = theX;
            this.mCount = theCount;
            this.mContext = theContext;
        }

        @Override
        public final long getContext() {
            return this.mContext;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public final long getCount() {
            return this.mCount;
        }

        @Override
        public LongUnaryCountImpl copy() {
            return new LongUnaryCountImpl(this.mX, this.mCount, this.mContext);
        }
    }

    private static abstract class AbstractUnaryCountImpl
    implements UnaryCount {
        private AbstractUnaryCountImpl() {
        }

        @Override
        public final boolean hasContext() {
            return this.getContext() != -1L;
        }

        @Override
        public int compareTo(UnaryCount o) {
            if (o == null) {
                return 1;
            }
            int comp = Longs.compare((long)this.getX(), (long)o.getX());
            if (comp == 0 && (comp = Longs.compare((long)this.getCount(), (long)o.getCount())) == 0) {
                comp = Longs.compare((long)this.getContext(), (long)o.getContext());
            }
            return comp;
        }

        public int hashCode() {
            return Longs.hashCode((long)this.getContext()) >> 2 ^ Longs.hashCode((long)this.getX()) >> 1 ^ Longs.hashCode((long)this.getCount()) << 1;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof UnaryCount) {
                UnaryCount o = (UnaryCount)obj;
                return this.getX() == o.getX() && this.getCount() == o.getCount() && this.getContext() == o.getContext();
            }
            return false;
        }

        public String toString() {
            return "(" + this.getX() + "){" + this.getContext() + "}=" + this.getCount();
        }
    }
}

