/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.index;

import com.complexible.stardog.index.MutableQuad;
import com.complexible.stardog.index.MutableSupportsContext;
import com.complexible.stardog.index.Quad;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;

public final class Quads {
    public static MutableQuad mutable(long theX, long theY, long theZ, long theContext) {
        return new MutableQuadImpl(theX, theY, theZ, theContext);
    }

    public static MutableQuad mutable(long theX, long theY, long theZ) {
        return new MutableQuadImpl(theX, theY, theZ, -1L);
    }

    public static Quad create(long theX, long theY, long theZ) {
        if (theY < Integer.MAX_VALUE) {
            boolean allInts = theZ > Integer.MIN_VALUE && theZ < Integer.MAX_VALUE && theX < Integer.MAX_VALUE;
            return allInts ? new IntNoContextQuadImpl(theX, theY, theZ) : new IntPredicateNoContextQuadImpl(theX, theY, theZ);
        }
        return new LongNoContextQuadImpl(theX, theY, theZ);
    }

    public static Quad create(long theX, long theY, long theZ, long theContext) {
        if (theContext == -1L) {
            return Quads.create(theX, theY, theZ);
        }
        if (theY < Integer.MAX_VALUE) {
            boolean allInts = theZ > Integer.MIN_VALUE && theZ < Integer.MAX_VALUE && theX < Integer.MAX_VALUE && theContext < Integer.MAX_VALUE;
            return allInts ? new IntQuadImpl(theX, theY, theZ, Ints.checkedCast((long)theContext)) : new IntPredicateQuadImpl(theX, theY, theZ, theContext);
        }
        return new LongQuadImpl(theX, theY, theZ, theContext);
    }

    private static final class MutableQuadImpl
    implements MutableQuad,
    MutableSupportsContext {
        private long mX;
        private long mY;
        private long mZ;
        private long mContext;

        public MutableQuadImpl(long theX, long theY, long theZ, long theContext) {
            this.mX = theX;
            this.mY = theY;
            this.mZ = theZ;
            this.mContext = theContext;
        }

        public MutableQuadImpl(long theX, long theY, long theZ) {
            this(theX, theY, theZ, -1L);
        }

        public MutableQuadImpl(Quad theQuad) {
            this(theQuad.getX(), theQuad.getY(), theQuad.getZ(), theQuad.getContext());
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public void setX(long theX) {
            this.mX = theX;
        }

        @Override
        public final long getY() {
            return this.mY;
        }

        @Override
        public void setY(long theY) {
            this.mY = theY;
        }

        @Override
        public final void set(long x, long y, long z, long ctx) {
            this.mX = x;
            this.mY = y;
            this.mZ = z;
            this.mContext = ctx;
        }

        @Override
        public final long getZ() {
            return this.mZ;
        }

        @Override
        public void setZ(long theZ) {
            this.mZ = theZ;
        }

        @Override
        public final long getContext() {
            return this.mContext;
        }

        @Override
        public void setContext(long theContext) {
            this.mContext = theContext;
        }

        @Override
        public final boolean hasContext() {
            return this.mContext != -1L;
        }

        @Override
        public int compareTo(Quad o) {
            if (o == null) {
                return 1;
            }
            int comp = Longs.compare((long)this.getX(), (long)o.getX());
            if (comp == 0 && (comp = Longs.compare((long)this.getY(), (long)o.getY())) == 0 && (comp = Longs.compare((long)this.getZ(), (long)o.getZ())) == 0) {
                comp = Longs.compare((long)this.getContext(), (long)o.getContext());
            }
            return comp;
        }

        @Override
        public MutableQuadImpl copy() {
            return new MutableQuadImpl(this.mX, this.mY, this.mZ, this.mContext);
        }

        public int hashCode() {
            return Longs.hashCode((long)this.mContext) >> 2 ^ Longs.hashCode((long)this.mX) >> 1 ^ Longs.hashCode((long)this.mY) ^ Longs.hashCode((long)this.mZ) << 1;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Quad) {
                Quad o = (Quad)obj;
                return this.mX == o.getX() && this.mY == o.getY() && this.mZ == o.getZ() && this.mContext == o.getContext();
            }
            return false;
        }

        public String toString() {
            return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + "){" + this.getContext() + "}";
        }
    }

    private static class IntNoContextQuadImpl
    extends AbstractQuadImpl {
        private final int mX;
        private final int mY;
        private final int mZ;

        private IntNoContextQuadImpl(long theX, long theY, long theZ) {
            this.mX = (int)theX;
            this.mY = (int)theY;
            this.mZ = (int)theZ;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public final long getY() {
            return this.mY;
        }

        @Override
        public final long getZ() {
            return this.mZ;
        }

        @Override
        public long getContext() {
            return -1L;
        }

        @Override
        public Quad copy() {
            return new IntNoContextQuadImpl(this.mX, this.mY, this.mZ);
        }
    }

    private static class IntPredicateNoContextQuadImpl
    extends AbstractQuadImpl {
        private final long mX;
        private final long mZ;
        private final int mY;

        private IntPredicateNoContextQuadImpl(long theX, long theY, long theZ) {
            this.mX = theX;
            this.mY = (int)theY;
            this.mZ = theZ;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public final long getY() {
            return this.mY;
        }

        @Override
        public final long getZ() {
            return this.mZ;
        }

        @Override
        public long getContext() {
            return -1L;
        }

        @Override
        public Quad copy() {
            return new IntPredicateNoContextQuadImpl(this.mX, this.mY, this.mZ);
        }
    }

    private static class LongNoContextQuadImpl
    extends AbstractQuadImpl {
        private final long mX;
        private final long mY;
        private final long mZ;

        private LongNoContextQuadImpl(long theX, long theY, long theZ) {
            this.mX = theX;
            this.mY = theY;
            this.mZ = theZ;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public final long getY() {
            return this.mY;
        }

        @Override
        public final long getZ() {
            return this.mZ;
        }

        @Override
        public long getContext() {
            return -1L;
        }

        @Override
        public Quad copy() {
            return new LongNoContextQuadImpl(this.mX, this.mY, this.mZ);
        }
    }

    private static class IntQuadImpl
    extends AbstractQuadImpl {
        private final int mX;
        private final int mY;
        private final int mZ;
        private final int mContext;

        private IntQuadImpl(long theX, long theY, long theZ, long theContext) {
            this.mX = (int)theX;
            this.mY = (int)theY;
            this.mZ = (int)theZ;
            this.mContext = (int)theContext;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public final long getY() {
            return this.mY;
        }

        @Override
        public final long getZ() {
            return this.mZ;
        }

        @Override
        public final long getContext() {
            return this.mContext;
        }

        @Override
        public Quad copy() {
            return new IntQuadImpl(this.mX, this.mY, this.mZ, this.mContext);
        }
    }

    private static class IntPredicateQuadImpl
    extends AbstractQuadImpl {
        private final long mX;
        private final long mZ;
        private final int mY;
        private final long mContext;

        private IntPredicateQuadImpl(long theX, long theY, long theZ, long theContext) {
            this.mX = theX;
            this.mY = (int)theY;
            this.mZ = theZ;
            this.mContext = theContext;
        }

        @Override
        public final long getContext() {
            return this.mContext;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public final long getY() {
            return this.mY;
        }

        @Override
        public final long getZ() {
            return this.mZ;
        }

        @Override
        public Quad copy() {
            return new IntPredicateQuadImpl(this.mX, this.mY, this.mZ, this.mContext);
        }
    }

    private static class LongQuadImpl
    extends AbstractQuadImpl {
        private final long mX;
        private final long mY;
        private final long mZ;
        private final long mContext;

        private LongQuadImpl(long theX, long theY, long theZ, long theContext) {
            this.mX = theX;
            this.mY = theY;
            this.mZ = theZ;
            this.mContext = theContext;
        }

        @Override
        public final long getContext() {
            return this.mContext;
        }

        @Override
        public final long getX() {
            return this.mX;
        }

        @Override
        public final long getY() {
            return this.mY;
        }

        @Override
        public final long getZ() {
            return this.mZ;
        }

        @Override
        public LongQuadImpl copy() {
            return new LongQuadImpl(this.mX, this.mY, this.mZ, this.mContext);
        }
    }

    public static abstract class AbstractQuadImpl
    implements Quad {
        @Override
        public final boolean hasContext() {
            return this.getContext() != -1L;
        }

        @Override
        public int compareTo(Quad o) {
            if (o == null) {
                return 1;
            }
            int comp = Longs.compare((long)this.getX(), (long)o.getX());
            if (comp == 0 && (comp = Longs.compare((long)this.getY(), (long)o.getY())) == 0 && (comp = Longs.compare((long)this.getZ(), (long)o.getZ())) == 0) {
                comp = Longs.compare((long)this.getContext(), (long)o.getContext());
            }
            return comp;
        }

        public int hashCode() {
            return Longs.hashCode((long)this.getContext()) >> 2 ^ Longs.hashCode((long)this.getX()) >> 1 ^ Longs.hashCode((long)this.getY()) ^ Longs.hashCode((long)this.getZ()) << 1;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Quad) {
                Quad o = (Quad)obj;
                return this.getX() == o.getX() && this.getY() == o.getY() && this.getZ() == o.getZ() && this.getContext() == o.getContext();
            }
            return false;
        }

        public String toString() {
            return "(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + "){" + this.getContext() + "}";
        }
    }
}

