/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.index;

import com.complexible.stardog.index.ContextCount;
import com.complexible.stardog.index.MutableContextCount;
import com.google.common.primitives.Longs;

public final class ContextCounts {
    public static ContextCount create(long theCount, long theContext) {
        return new ContextCountImpl(theCount, theContext);
    }

    public static MutableContextCount mutable(long theCount, long theContext) {
        return new MutableContextCountImpl(theCount, theContext);
    }

    private static class ContextCountImpl
    implements ContextCount {
        protected long mCount;
        protected long mContext;

        public ContextCountImpl(long theCount, long theContext) {
            this.mCount = theCount;
            this.mContext = theContext;
        }

        @Override
        public final long getCount() {
            return this.mCount;
        }

        @Override
        public final long getContext() {
            return this.mContext;
        }

        @Override
        public final boolean hasContext() {
            return this.mContext != -1L;
        }

        @Override
        public int compareTo(ContextCount o) {
            int comp;
            long aTripleContext = o.getContext();
            int n = comp = this.mContext == 0L || aTripleContext == 0L ? 0 : Longs.compare((long)this.mContext, (long)aTripleContext);
            if (comp == 0) {
                comp = Longs.compare((long)this.mCount, (long)o.getCount());
            }
            return comp;
        }

        @Override
        public ContextCountImpl copy() {
            return new ContextCountImpl(this.mCount, this.mContext);
        }

        public int hashCode() {
            return Longs.hashCode((long)this.mContext) >> 1 ^ Longs.hashCode((long)this.mCount) << 1;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ContextCount) {
                ContextCount o = (ContextCount)obj;
                return this.mCount == o.getCount() && this.mContext == o.getContext();
            }
            return false;
        }

        public String toString() {
            return "{" + this.getContext() + "}=" + this.getCount();
        }
    }

    private static class MutableContextCountImpl
    extends ContextCountImpl
    implements MutableContextCount {
        public MutableContextCountImpl(long theCount, long theContext) {
            super(theCount, theContext);
        }

        @Override
        public void setContext(long theContext) {
            this.mContext = theContext;
        }

        @Override
        public void setCount(long theCount) {
            this.mCount = theCount;
        }
    }
}

