/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util.concurrent;

import com.complexible.common.util.concurrent.Clock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

public class SystemClock
implements Clock {
    public static final Clock INSTANCE = new SystemClock();

    private SystemClock() {
    }

    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long currentTimeNanos() {
        return System.nanoTime();
    }

    @Override
    public long sleep(long time, TimeUnit unit) throws InterruptedException {
        long sleepTimeNanoes = unit.toNanos(time);
        long sTime = System.nanoTime();
        LockSupport.parkNanos(unit.toNanos(time));
        long eTime = System.nanoTime();
        return unit.convert(sleepTimeNanoes - (sTime - eTime), TimeUnit.NANOSECONDS);
    }
}

