/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util.concurrent;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SharedForkJoinExecutor {
    public static final int CONCURRENCY_LEVEL = Math.max(1, Runtime.getRuntime().availableProcessors() >> 1);
    private static final Logger LOGGER = LoggerFactory.getLogger(SharedForkJoinExecutor.class);
    private static final ForkJoinPool EXEC = new ForkJoinPool(CONCURRENCY_LEVEL, pool -> {
        ForkJoinWorkerThread aThread = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
        aThread.setName("ForkJoin-Executor-" + aThread.getPoolIndex());
        return aThread;
    }, (t, e) -> LOGGER.info("Uncaught exception in SharedForkJoinExecutor.", e), true);

    public static void shutdown() {
        EXEC.shutdown();
    }

    public static ForkJoinPool get() {
        return EXEC;
    }
}

