/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class BlockingThreadPoolExecutor
extends ThreadPoolExecutor {
    private final Semaphore mSemaphore;
    private ExceptionHandler mExceptionHandler = new SilentExceptionHandler();

    public BlockingThreadPoolExecutor(int theCorePoolSize, int theMaxPoolSize, long theKeepAliveTime, TimeUnit theTimeUnit, BlockingQueue<Runnable> theWorkQueue, int theBoundedSize) {
        super(theCorePoolSize, theMaxPoolSize, theKeepAliveTime, theTimeUnit, theWorkQueue);
        this.mSemaphore = new Semaphore(theBoundedSize);
    }

    public BlockingThreadPoolExecutor(int theCorePoolSize, int theMaxPoolSize, long theKeepAliveTime, TimeUnit theTimeUnit, BlockingQueue<Runnable> theWorkQueue, ThreadFactory theThreadFactory, int theBoundedSize) {
        super(theCorePoolSize, theMaxPoolSize, theKeepAliveTime, theTimeUnit, theWorkQueue, theThreadFactory);
        this.mSemaphore = new Semaphore(theBoundedSize);
    }

    public BlockingThreadPoolExecutor(int theCorePoolSize, int theMaxPoolSize, long theKeepAliveTime, TimeUnit theTimeUnit, BlockingQueue<Runnable> theWorkQueue, RejectedExecutionHandler theRejectedExecutionHandler, int theBoundedSize) {
        super(theCorePoolSize, theMaxPoolSize, theKeepAliveTime, theTimeUnit, theWorkQueue, theRejectedExecutionHandler);
        this.mSemaphore = new Semaphore(theBoundedSize);
    }

    public BlockingThreadPoolExecutor(int theCorePoolSize, int theMaxPoolSize, long theKeepAliveTime, TimeUnit theTimeUnit, BlockingQueue<Runnable> theWorkQueue, ThreadFactory theThreadFactory, RejectedExecutionHandler theRejectedExecutionHandler, int theBoundedSize) {
        super(theCorePoolSize, theMaxPoolSize, theKeepAliveTime, theTimeUnit, theWorkQueue, theThreadFactory, theRejectedExecutionHandler);
        this.mSemaphore = new Semaphore(theBoundedSize);
    }

    public void setExceptionHandler(ExceptionHandler theExceptionHandler) {
        this.mExceptionHandler = theExceptionHandler;
    }

    @Override
    public void execute(Runnable task) {
        boolean aSemaphoreAcquired = false;
        do {
            try {
                this.mSemaphore.acquire();
                aSemaphoreAcquired = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!aSemaphoreAcquired);
        try {
            super.execute(task);
        }
        catch (RuntimeException e) {
            this.mSemaphore.release();
            throw e;
        }
        catch (Error e) {
            this.mSemaphore.release();
            throw e;
        }
    }

    @Override
    protected void afterExecute(Runnable theRunnable, Throwable theThrowable) {
        this.mSemaphore.release();
        super.afterExecute(theRunnable, theThrowable);
        Throwable aCause = theThrowable;
        if (aCause == null && theRunnable instanceof Future) {
            try {
                Future future = (Future)((Object)theRunnable);
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException ce) {
                aCause = ce;
            }
            catch (ExecutionException ee) {
                aCause = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (aCause != null) {
            this.mExceptionHandler.handleException(aCause);
        }
    }

    public static class SilentExceptionHandler
    implements ExceptionHandler {
        @Override
        public void handleException(Throwable theThrowable) {
        }
    }

    public static interface ExceptionHandler {
        public void handleException(Throwable var1);
    }
}

