/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ThreadDump {
    private final ThreadMXBean threadMXBean;
    private final Comparator<Map.Entry<List<StackTraceElement>, List<ThreadInfo>>> comparator;

    public ThreadDump(ThreadMXBean threadMXBean) {
        this(threadMXBean, null);
    }

    public ThreadDump(ThreadMXBean threadMXBean, Comparator<Map.Entry<List<StackTraceElement>, List<ThreadInfo>>> comparator) {
        this.threadMXBean = threadMXBean;
        this.comparator = comparator;
    }

    public static String defaultDump(boolean includeLocks) {
        Comparator<Map.Entry<List<StackTraceElement>, List<ThreadInfo>>> comparator = Comparator.comparingInt(e -> Iterables.any((Iterable)((Iterable)e.getKey()), ste -> ste.toString().contains("stardog")) ? -((List)e.getKey()).size() : ((List)e.getValue()).size());
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        ThreadDump threadDump = new ThreadDump(threadMxBean, comparator);
        return threadDump.dump(includeLocks, includeLocks);
    }

    public String dump(boolean lockedMonitors, boolean lockedSynchronizers) {
        ThreadInfo[] threads = this.threadMXBean.dumpAllThreads(lockedMonitors, lockedSynchronizers);
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        ArrayListMultimap threadDumps = ArrayListMultimap.create();
        for (ThreadInfo thread : threads) {
            threadDumps.put(Arrays.asList(thread.getStackTrace()), (Object)thread);
        }
        ImmutableList groupedThreads = Multimaps.asMap((ListMultimap)threadDumps).entrySet();
        if (this.comparator != null) {
            groupedThreads = Ordering.from(this.comparator).immutableSortedCopy(groupedThreads);
        }
        for (Map.Entry entry : groupedThreads) {
            List threadList = (List)entry.getValue();
            if (threadList.size() > 1) {
                writer.printf("%d threads with the following stack trace:%n", threadList.size());
            }
            for (ThreadInfo t : threadList) {
                writer.printf("\"%s\" id=%d state=%s", new Object[]{t.getThreadName(), t.getThreadId(), t.getThreadState()});
                LockInfo lock = t.getLockInfo();
                if (lock != null && t.getThreadState() != Thread.State.BLOCKED) {
                    writer.printf("%n    - waiting on <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
                    writer.printf("%n    - locked <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
                } else if (lock != null && t.getThreadState() == Thread.State.BLOCKED) {
                    writer.printf("%n    - waiting to lock <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
                }
                if (t.isSuspended()) {
                    writer.print(" (suspended)");
                }
                if (t.isInNative()) {
                    writer.print(" (running in native)");
                }
                writer.println();
                if (t.getLockOwnerName() == null) continue;
                writer.printf("     owned by %s id=%d%n", t.getLockOwnerName(), t.getLockOwnerId());
            }
            ThreadInfo t = (ThreadInfo)threadList.iterator().next();
            StackTraceElement[] elements = t.getStackTrace();
            MonitorInfo[] monitors = t.getLockedMonitors();
            for (int i = 0; i < elements.length; ++i) {
                StackTraceElement element = elements[i];
                writer.printf("    at %s%n", element);
                for (int j = 1; j < monitors.length; ++j) {
                    MonitorInfo monitor = monitors[j];
                    if (monitor.getLockedStackDepth() != i) continue;
                    writer.printf("      - locked %s%n", monitor);
                }
            }
            writer.println();
            LockInfo[] locks = t.getLockedSynchronizers();
            if (locks.length <= 0) continue;
            writer.printf("    Locked synchronizers: count = %d%n", locks.length);
            for (LockInfo l : locks) {
                writer.printf("      - %s%n", l);
            }
            writer.println();
        }
        writer.println();
        writer.flush();
        return sw.toString();
    }
}

