/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util;

import com.complexible.common.base.Disposable;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ShutDownHookManager {
    private static final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private static final List<ShutdownWorker> toShutdown = new CopyOnWriteArrayList<ShutdownWorker>();

    public static void register(String theName, Runnable theInvoker, int thePriority) {
        if (isShutdown.get()) {
            theInvoker.run();
        } else {
            toShutdown.add(new ShutdownWorker(theName, theInvoker, thePriority));
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("ShutdownHookManager"){

            @Override
            public void run() {
                if (!isShutdown.compareAndSet(false, true)) {
                    return;
                }
                Exception e = null;
                toShutdown.sort(Comparator.comparingInt(ShutdownWorker::priority));
                for (ShutdownWorker sh : toShutdown) {
                    try {
                        sh.dispose();
                    }
                    catch (Exception ee) {
                        if (e == null) {
                            e = ee;
                            continue;
                        }
                        e.addSuppressed(ee);
                    }
                }
                toShutdown.clear();
                if (e != null) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static final class ShutdownWorker
    implements Disposable {
        private final Runnable mTask;
        private final int mPriority;
        private final String mName;

        public ShutdownWorker(String theName, Runnable theTask, int thePriority) {
            this.mTask = theTask;
            this.mPriority = thePriority;
            this.mName = theName;
        }

        public String name() {
            return this.mName;
        }

        @Override
        public void dispose() {
            this.mTask.run();
        }

        public int priority() {
            return this.mPriority;
        }
    }
}

