/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util;

import com.complexible.common.base.Instrumentor;
import com.complexible.common.base.SystemUtil;
import com.complexible.common.util.ClassServiceLoader;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.ServiceConfigurationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceLoaders {
    private static final boolean INSTRUMENT = SystemUtil.getPropertyAsBoolean("com.complexible.common.util.ServiceLoaders.instrument", false);
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceLoaders.class);

    private ServiceLoaders() {
        throw new AssertionError();
    }

    public static <T> Collection<T> instancesOf(Class<T> theClass) {
        ArrayList aInsts = Lists.newArrayList();
        for (Class<T> aClass : ClassServiceLoader.classesOf(theClass)) {
            try {
                aInsts.add(aClass.newInstance());
            }
            catch (InstantiationException e) {
                throw new ServiceConfigurationError(String.format("Could not create class %s, no default constructor.", aClass), e);
            }
            catch (IllegalAccessException e) {
                throw new ServiceConfigurationError(String.format("Could not create class %s, no public constructor or class is not public", aClass), e);
            }
            catch (Exception e) {
                LOGGER.warn("Could not create class", (Throwable)e);
            }
        }
        if (INSTRUMENT && Instrumentor.isInitialized()) {
            for (Class<T> aClass : Instrumentor.instancesOf(theClass)) {
                try {
                    aInsts.add(aClass.newInstance());
                }
                catch (InstantiationException e) {
                    LOGGER.warn("Error trying to initialize module, no default constructor found for class: " + String.valueOf(aClass));
                }
                catch (IllegalAccessException e) {
                    LOGGER.warn("Error trying to initialize module, not able to access default constructor for class: " + String.valueOf(aClass));
                }
                catch (Exception e) {
                    LOGGER.warn("Could not create class", (Throwable)e);
                }
            }
        }
        return aInsts;
    }

    public static <T> Collection<Class<? extends T>> classesOf(Class<T> theClass) {
        HashSet aClasses = Sets.newHashSet();
        if (INSTRUMENT && Instrumentor.isInitialized()) {
            aClasses.addAll(Instrumentor.instancesOf(theClass));
        }
        Iterables.addAll((Collection)aClasses, ClassServiceLoader.classesOf(theClass));
        return aClasses;
    }
}

