/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util;

import com.complexible.common.util.NamespaceUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;

public class PrefixMapping {
    public static final PrefixMapping GLOBAL = new PrefixMapping();
    private Map<String, String> uriToPrefix = Maps.newHashMap();
    private Map<String, String> prefixToUri = Maps.newHashMap();

    public PrefixMapping() {
        this(true);
    }

    public PrefixMapping(boolean theAddDefaults) {
        if (theAddDefaults) {
            this.addMapping("owl", "http://www.w3.org/2002/07/owl#");
            this.addMapping("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
            this.addMapping("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
            this.addMapping("xsd", "http://www.w3.org/2001/XMLSchema#");
        }
    }

    public String getPrefix(String uri) {
        return this.uriToPrefix.get(uri);
    }

    public String getNamespace(String prefix) {
        return this.prefixToUri.get(prefix);
    }

    public boolean addMapping(String prefix, String uri) {
        Preconditions.checkNotNull((Object)prefix, (Object)"Prefix cannot be null");
        Preconditions.checkNotNull((Object)uri, (Object)"Namespace URI cannot be null");
        String currentUri = this.getNamespace(prefix);
        if (currentUri == null) {
            this.prefixToUri.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
            return true;
        }
        return currentUri.equals(uri);
    }

    public void setMapping(String prefix, String uri) {
        Preconditions.checkNotNull((Object)prefix, (Object)"Prefix cannot be null");
        Preconditions.checkNotNull((Object)uri, (Object)"Namespace URI cannot be null");
        this.prefixToUri.put(prefix, uri);
        this.uriToPrefix.put(uri, prefix);
    }

    public boolean removeMapping(String prefix, String uri) {
        String aPrefixMapping = this.prefixToUri.get(prefix);
        String aURIMapping = this.uriToPrefix.get(uri);
        if (aPrefixMapping.equals(uri) && aURIMapping.equals(prefix)) {
            this.prefixToUri.remove(prefix);
            this.uriToPrefix.remove(uri);
            return true;
        }
        return false;
    }

    public void clear() {
        this.uriToPrefix.clear();
        this.prefixToUri.clear();
    }

    public Collection<String> getPrefixes() {
        return this.prefixToUri.keySet();
    }

    public String qname(String uri) {
        return this.qname(uri, true);
    }

    public String qname(String uri, boolean autoGenerate) {
        if (uri == null) {
            return null;
        }
        int splitPos = NamespaceUtils.findLastNameIndex(uri);
        if (splitPos <= 0) {
            return uri;
        }
        String nameSpace = uri.substring(0, splitPos);
        String localName = uri.substring(splitPos);
        Object prefix = this.getPrefix(nameSpace);
        if (prefix != null) {
            return (String)prefix + ":" + localName;
        }
        if (!autoGenerate) {
            return uri;
        }
        int prefixStart = NamespaceUtils.findNameStartIndex(nameSpace);
        if (prefixStart < 0) {
            prefix = "ns";
        } else {
            int prefixEnd = NamespaceUtils.findNextNonNameIndex(nameSpace, prefixStart + 1);
            prefix = uri.substring(prefixStart, prefixEnd);
            if (((String)prefix).length() > 1 && Character.isUpperCase(((String)prefix).charAt(0)) && !Character.isUpperCase(((String)prefix).charAt(1))) {
                prefix = Character.toLowerCase(((String)prefix).charAt(0)) + ((String)prefix).substring(1, ((String)prefix).length());
            }
        }
        prefix = this.setAutoIncrementPrefix((String)prefix, nameSpace);
        return (String)prefix + ":" + localName;
    }

    private String setAutoIncrementPrefix(String prefix, String namespace) {
        Object result = prefix;
        int mod = 0;
        while (!this.addMapping((String)result, namespace)) {
            result = prefix + mod;
            ++mod;
        }
        return result;
    }

    public String uri(String qname) {
        if (qname == null) {
            return qname;
        }
        String[] str = qname.split(":");
        String aNamespace = this.getNamespace(str[0]);
        if (aNamespace == null) {
            return qname;
        }
        return aNamespace + str[1];
    }

    public String toString() {
        return this.prefixToUri.toString();
    }
}

