/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util;

public class NamespaceUtils {
    public static boolean isNameStartChar(char ch) {
        return Character.isLetter(ch) || ch == '_';
    }

    public static boolean isNameChar(char ch) {
        return NamespaceUtils.isNameStartChar(ch) || Character.isDigit(ch) || ch == '.' || ch == '-';
    }

    public static int findNameStartIndex(String str) {
        char[] strChars = str.toCharArray();
        int nameStartIndex = -1;
        boolean foundNameChar = false;
        for (int strIndex = strChars.length - 1; strIndex >= 0; --strIndex) {
            char letter = strChars[strIndex];
            if (NamespaceUtils.isNameStartChar(letter)) {
                nameStartIndex = strIndex;
                foundNameChar = true;
                continue;
            }
            if (foundNameChar && !NamespaceUtils.isNameChar(letter)) break;
        }
        return nameStartIndex;
    }

    public static int findLastNameIndex(String str) {
        char letter;
        char[] strChars = str.toCharArray();
        int nameIndex = -1;
        int strIndex = strChars.length - 1;
        while (strIndex >= 0 && NamespaceUtils.isNameChar(letter = strChars[strIndex])) {
            nameIndex = strIndex--;
        }
        return nameIndex;
    }

    public static int findNextNonNameIndex(String str, int startIndex) {
        char letter;
        char[] strChars = str.toCharArray();
        int nameIndex = startIndex;
        for (nameIndex = startIndex; nameIndex < strChars.length && NamespaceUtils.isNameChar(letter = strChars[nameIndex]) && letter != '.'; ++nameIndex) {
        }
        return nameIndex;
    }
}

