/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public final class Krb5Utils {
    Krb5Utils() {
    }

    public static void forEach(File theKeytab, Consumer<String> theTallable) throws IOException {
        List<String> names = Krb5Utils.getPrincipalNames(theKeytab);
        for (String principal : names) {
            theTallable.accept(principal);
        }
    }

    public static List<String> getPrincipalNames(File keyTab) throws IOException {
        ArrayList<String> principalList = new ArrayList<String>();
        ByteBuffer aBuffer = Krb5Utils.readAll(keyTab);
        byte[] version = Krb5Utils.getKeytabVersion(aBuffer);
        while (aBuffer.remaining() > 0) {
            int size = aBuffer.getInt();
            if (size < 0 || size > aBuffer.capacity()) {
                throw new IOException("Invalid size for the keytab entry");
            }
            byte[] entry = new byte[size];
            aBuffer.get(entry);
            String p = Krb5Utils.processEntry(entry);
            principalList.add(p);
        }
        return principalList;
    }

    static byte[] getKeytabVersion(ByteBuffer buffer) {
        byte[] version = new byte[2];
        buffer.get(version);
        return version;
    }

    static String processEntry(byte[] entry) throws IOException {
        ByteBuffer entBuf = ByteBuffer.wrap(entry);
        int count = entBuf.getShort();
        String realm = Krb5Utils.getCountedString(entBuf);
        StringBuffer principalNameBuffer = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            String nameComponent = Krb5Utils.getCountedString(entBuf);
            principalNameBuffer.append(nameComponent);
            if (i >= count - 1) continue;
            principalNameBuffer.append("/");
        }
        principalNameBuffer.append("@").append(realm);
        return principalNameBuffer.toString();
    }

    private static String getCountedString(ByteBuffer buffer) throws IOException {
        short length = buffer.getShort();
        if (length >= 0 && length <= buffer.capacity()) {
            byte[] data = new byte[length];
            buffer.get(data);
            try {
                return new String(data, "ASCII");
            }
            catch (UnsupportedEncodingException var5) {
                return "";
            }
        }
        throw new IOException("Invalid size for the keytab entry");
    }

    protected static ByteBuffer readAll(File keyTab) throws IOException {
        long totalSizeL = keyTab.length();
        if (totalSizeL >= 0x10000000L) {
            throw new IOException("That keytab file is just way too big");
        }
        int totalSize = (int)totalSizeL;
        byte[] dataBytes = new byte[totalSize];
        try (FileInputStream fis = new FileInputStream(keyTab);){
            int totalRead = 0;
            int length = totalSize;
            while (totalRead < totalSize) {
                int count = fis.read(dataBytes, totalRead, length);
                if (count < 0) {
                    throw new IOException("EOF prematuraly hit");
                }
                totalRead += count;
                length -= count;
            }
            if (totalRead != totalSize) {
                throw new IOException("Keytab not properly read");
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(dataBytes);
            return byteBuffer;
        }
    }
}

