/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util;

import com.complexible.common.base.Copyable;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;

public class EnhancedProperties
extends Properties
implements Copyable<EnhancedProperties> {
    public EnhancedProperties() {
    }

    public EnhancedProperties(InputStream theInput) throws IOException {
        this.load(theInput);
    }

    public EnhancedProperties(Properties theProps) {
        for (Object aKey : theProps.keySet()) {
            this.put(aKey, theProps.get(aKey));
        }
    }

    public boolean getPropertyAsBoolean(String theProp) {
        return super.getProperty(theProp) != null && Boolean.valueOf(super.getProperty(theProp)) != false;
    }

    public boolean getPropertyAsBoolean(String theProperty, boolean theDefault) {
        return super.getProperty(theProperty) == null ? theDefault : Boolean.valueOf(super.getProperty(theProperty));
    }

    @Override
    public String getProperty(String theProp) {
        String aValue = super.getProperty(theProp);
        if (aValue != null) {
            aValue = this.replaceVariables(aValue);
        }
        return aValue;
    }

    @Override
    public synchronized Object put(Object theKey, Object theValue) {
        if (theKey != null && theValue != null) {
            return super.put(theKey.toString().trim(), theValue.toString().trim());
        }
        return null;
    }

    public int getPropertyAsInt(String theProp, int theDefault) throws NumberFormatException {
        return Integer.parseInt(this.getProperty(theProp, String.valueOf(theDefault)));
    }

    public int getPropertyAsInt(String theProp) throws NumberFormatException {
        return Integer.parseInt(this.getProperty(theProp));
    }

    public long getPropertyAsLong(String theProperty, long theDefault) throws NumberFormatException {
        return Long.parseLong(this.getProperty(theProperty, String.valueOf(theDefault)));
    }

    public long getPropertyAsLong(String theProperty) throws NumberFormatException {
        return Long.parseLong(this.getProperty(theProperty));
    }

    public float getPropertyAsFloat(String theProperty, float theDefault) throws NumberFormatException {
        return Float.parseFloat(this.getProperty(theProperty, String.valueOf(theDefault)));
    }

    public float getPropertyAsFloat(String theProperty) throws NumberFormatException {
        return Float.parseFloat(this.getProperty(theProperty));
    }

    public double getPropertyAsDouble(String theProperty) throws NumberFormatException {
        return Double.parseDouble(this.getProperty(theProperty));
    }

    public double getPropertyAsDouble(String theProperty, double theDefault) throws NumberFormatException {
        return Double.parseDouble(this.getProperty(theProperty, String.valueOf(theDefault)));
    }

    public List<String> getPropertyAsList(String theProp) {
        String[] aElems;
        String aValue = this.getProperty(theProp);
        if (aValue == null) {
            return null;
        }
        ArrayList<String> aList = new ArrayList<String>();
        for (String aElem : aElems = aValue.split(",")) {
            aList.add(aElem.trim());
        }
        return aList;
    }

    public Map<String, String> getPropertyAsMap(String theProp) {
        List<String> aList = this.getPropertyAsList(theProp);
        HashMap<String, String> aMap = new HashMap<String, String>();
        for (String aKey : aList) {
            String aValue = this.getProperty(aKey);
            if (aValue == null) continue;
            aMap.put(aKey, aValue);
        }
        return aMap;
    }

    private String replaceVariables(String theValue) {
        StringBuffer aNewValue = new StringBuffer(theValue);
        int aIndex = 0;
        while (aNewValue.indexOf("${", aIndex) != -1) {
            String aVar = aNewValue.substring(aNewValue.indexOf("${", aIndex) + 2, aNewValue.indexOf("}", aIndex));
            int end = aNewValue.indexOf("}", aIndex);
            if (super.getProperty(aVar) != null) {
                int aLength = aNewValue.length();
                aNewValue.replace(aNewValue.indexOf("${", aIndex), aNewValue.indexOf("}", aIndex) + 1, this.replaceVariables(super.getProperty(aVar)));
                int aNewLength = aNewValue.length();
                end += aNewLength - aLength;
            }
            aIndex = end;
        }
        return aNewValue.toString();
    }

    @Override
    public EnhancedProperties copy() {
        return new EnhancedProperties(this);
    }

    public EnhancedProperties select(Predicate<String> theKeySelector) {
        EnhancedProperties aProps = new EnhancedProperties();
        for (Object aKey : this.keySet()) {
            if (!theKeySelector.test(aKey.toString())) continue;
            aProps.put(aKey, this.get(aKey));
        }
        return aProps;
    }

    public EnhancedProperties transformKeys(Function<String, String> theKeyFunction) {
        EnhancedProperties aProps = new EnhancedProperties();
        for (Object aKey : this.keySet()) {
            aProps.put(theKeyFunction.apply(aKey.toString()), this.get(aKey));
        }
        return aProps;
    }

    public EnhancedProperties transformValues(Function<String, String> theValueFunction) {
        EnhancedProperties aProps = new EnhancedProperties();
        for (Object aKey : this.keySet()) {
            aProps.put(aKey, theValueFunction.apply(this.getProperty(aKey.toString())));
        }
        return aProps;
    }

    public Iterable<EnhancedProperties> partitionByKeys(Function<String, String> thePartitionFunction) {
        HashMap aMap = Maps.newHashMap();
        for (Object aKey : this.keySet()) {
            String aKeyStr = aKey.toString();
            String aMapKey = thePartitionFunction.apply(aKeyStr);
            EnhancedProperties aProps = (EnhancedProperties)aMap.get(aMapKey);
            if (aProps == null) {
                aProps = new EnhancedProperties();
                aMap.put(aMapKey, aProps);
            }
            aProps.put(aKey, this.get(aKey));
        }
        return aMap.values();
    }

    public static boolean containsKeyIgnoreCase(Properties properties, String key) {
        return properties.keySet().stream().map(String.class::cast).anyMatch(k -> k.equalsIgnoreCase(key));
    }
}

