/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.util;

import com.google.common.base.Charsets;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ServiceConfigurationError;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassServiceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassServiceLoader.class);
    private static final String PREFIX = "META-INF/services/";
    private static final Cache<Class, Iterable> mCache = CacheBuilder.newBuilder().softValues().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    public static <S> Iterable<Class<? extends S>> classesOf(Class<S> theClass) {
        try {
            Iterable aIterable = (Iterable)mCache.getIfPresent(theClass);
            if (aIterable == null) {
                ClassLoader aClassLoader = ClassServiceLoader.classLoaderToUse();
                Enumeration<URL> aResources = aClassLoader.getResources(PREFIX + theClass.getName());
                HashSet aClasses = Sets.newHashSet();
                while (aResources.hasMoreElements()) {
                    URL aResource = aResources.nextElement();
                    Iterables.addAll((Collection)aClasses, (Iterable)((Iterable)Resources.readLines((URL)aResource, (Charset)Charsets.UTF_8, new ClassLineProcessor(aClassLoader))));
                }
                aIterable = aClasses;
                mCache.put(theClass, (Object)aIterable);
            }
            return aIterable;
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new ServiceConfigurationError("Could not parse or find the service file", e);
        }
    }

    private static ClassLoader classLoaderToUse() {
        ClassLoader aClassLoader = null;
        try {
            aClassLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (aClassLoader == null) {
            aClassLoader = ClassServiceLoader.class.getClassLoader();
        }
        return aClassLoader;
    }

    private static final class ClassLineProcessor<S>
    implements LineProcessor<Iterable<Class<? extends S>>> {
        private final ImmutableList.Builder<Class<? extends S>> mBuilder = ImmutableList.builder();
        private final ClassLoader mClassLoader;

        ClassLineProcessor(ClassLoader theClassLoader) {
            this.mClassLoader = theClassLoader;
        }

        public boolean processLine(String theLine) throws IOException {
            try {
                String aLine = theLine;
                if (aLine.contains("#")) {
                    aLine = aLine.substring(0, aLine.indexOf("#"));
                }
                if ((aLine = aLine.trim()).equals("")) {
                    return true;
                }
                this.mBuilder.add(Class.forName(aLine, true, this.mClassLoader));
                return true;
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                String aMsg = String.format("A class name specified in the service definition, %s, did not exist.", theLine);
                LOGGER.info(aMsg);
                return true;
            }
        }

        public Iterable<Class<? extends S>> getResult() {
            return this.mBuilder.build();
        }
    }
}

