/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.unsafe;

import com.complexible.common.base.SystemUtil;
import java.lang.reflect.Field;
import java.security.AccessController;
import sun.misc.Unsafe;

public final class UnsafeUtil {
    public static final Unsafe UNSAFE;
    public static final boolean UNSAFE_AVAILABLE;

    private UnsafeUtil() {
    }

    private static Unsafe getUnsafe() {
        Unsafe unsafe = null;
        try {
            unsafe = AccessController.doPrivileged(() -> {
                Class<Unsafe> k = Unsafe.class;
                for (Field f : k.getDeclaredFields()) {
                    f.setAccessible(true);
                    Object x = f.get(null);
                    if (!k.isInstance(x)) continue;
                    return (Unsafe)k.cast(x);
                }
                return null;
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return unsafe;
    }

    static {
        boolean unsafeEnabled = SystemUtil.getPropertyAsBoolean("memory.management.unsafe.enabled", true);
        if (unsafeEnabled) {
            Unsafe unsafe;
            try {
                unsafe = UnsafeUtil.getUnsafe();
            }
            catch (Throwable t) {
                unsafe = null;
            }
            UNSAFE = unsafe;
        } else {
            UNSAFE = null;
        }
        UNSAFE_AVAILABLE = UNSAFE != null;
    }
}

