/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.trie;

import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ByteWriter;
import com.complexible.common.trie.Node;
import com.complexible.common.trie.PrefixTree;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class TrieOps {
    public static <T> void persist(ByteWriter theWriter, PrefixTree<T> theTrie) throws IOException {
        theWriter.writeVLong(theTrie.size());
        TrieOps.persist(theWriter, theTrie.getRoot(), Lists.newLinkedList());
    }

    private static <T> void persist(ByteWriter theWriter, Node<T> theNode, List<Long> theKeySoFar) throws IOException {
        if (theNode.getValue() != null) {
            theWriter.writeVInt(theKeySoFar.size());
            Iterator<Object> iterator = theKeySoFar.iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                theWriter.writeVLong(l);
            }
        }
        for (LongObjectCursor longObjectCursor : theNode.getChildren()) {
            theKeySoFar.add(longObjectCursor.key);
            TrieOps.persist(theWriter, (Node)longObjectCursor.value, theKeySoFar);
            theKeySoFar.remove(theKeySoFar.size() - 1);
        }
    }

    public static <T> void read(ByteReader theReader, PrefixTree<T> theTrie, T theEmptyValue) throws IOException {
        long aSize = theReader.readVLong();
        int i = 0;
        while ((long)i < aSize) {
            int aKeyLength = theReader.readVInt();
            long[] aKey = new long[aKeyLength];
            for (int j = 0; j < aKey.length; ++j) {
                aKey[j] = theReader.readVLong();
            }
            Arrays.sort(aKey);
            theTrie.put(aKey, theEmptyValue);
            ++i;
        }
    }

    public static <T> boolean merge(PrefixTree<T> theTrie, long[] theKey, T theObject, Merger<T> theMergeFunction) {
        ArrayList aNodes = Lists.newArrayList();
        theTrie.visitMaxSubsets(theKey, aNodes::add);
        if (aNodes.isEmpty()) {
            theTrie.visitMinSupersets(theKey, aNodes::add);
        }
        if (aNodes.isEmpty()) {
            return false;
        }
        theMergeFunction.merge(theObject, aNodes);
        return true;
    }

    public static interface Merger<T> {
        public void merge(T var1, List<Node<T>> var2);
    }
}

