/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.trie;

import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.complexible.common.trie.Node;
import com.complexible.common.trie.PrefixTree;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public class Trie<T>
extends PrefixTree<T> {
    private final Node<T> root = new Node();
    private long size = 0L;
    private long nodes = 0L;

    @Override
    public Node<T> getRoot() {
        return this.root;
    }

    @Override
    public boolean put(long[] key, T value) {
        Preconditions.checkNotNull(value);
        PathToNode<T> aSearchResult = this.search(key);
        Node<T> aLastInTrie = aSearchResult.node;
        for (int height = aSearchResult.path.size(); height < key.length; ++height) {
            aLastInTrie = aLastInTrie.addChild(key[height]);
            ++this.nodes;
        }
        if (!aLastInTrie.isObjectNode()) {
            ++this.size;
        } else if (aLastInTrie.getValue() != null && value.equals(aLastInTrie.getValue())) {
            return false;
        }
        aLastInTrie.setValue(value);
        aLastInTrie.setPath(key);
        return true;
    }

    @Override
    public T get(long[] key) {
        Node<T> aNode = this.getNodeForValue(key);
        return aNode == null ? null : (T)aNode.getValue();
    }

    private Node<T> getNodeForValue(long[] key) {
        PathToNode<T> aLastInTrie = this.search(key);
        return aLastInTrie.path.size() == key.length ? aLastInTrie.node : null;
    }

    public PathToNode<T> search(long[] key) {
        ArrayList aPath = Lists.newArrayList();
        Node<T> aStart = this.root;
        Node<T> aResult = null;
        key = this.normalize(key);
        for (int height = 0; height < key.length && aStart != null; aStart = aStart.getChild(key[height]), ++height) {
            aResult = aStart;
            aPath.add(key[height]);
        }
        if (aStart != null) {
            return new PathToNode<T>(aStart, aPath);
        }
        aPath.remove(aPath.size() - 1);
        return new PathToNode<T>(aResult, aPath);
    }

    @Override
    public Collection<T> getAllMatchingValues(long[] key) {
        Collection<Node<T>> aFrontier = this.getMatchingStartNodes(key);
        ArrayList aMatchingValues = Lists.newArrayList();
        for (Node<T> aNode : aFrontier) {
            this.traverse(aNode, aMatchingValues);
        }
        return aMatchingValues;
    }

    @Override
    public Collection<Node<T>> getMatchingStartNodes(long[] key) {
        ArrayDeque aFrontier = Queues.newArrayDeque();
        ArrayDeque aNextFrontier = Queues.newArrayDeque();
        aFrontier.add(this.root);
        for (int i = 0; i < key.length && !aFrontier.isEmpty(); ++i) {
            long aKeyElement = key[i];
            while (!aFrontier.isEmpty()) {
                Node aNode = (Node)aFrontier.poll();
                Node aNext = aNode.getChild(aKeyElement);
                if (aNext != null) {
                    aNextFrontier.add(aNext);
                }
                for (LongObjectCursor c : aNode.getChildren()) {
                    if (c.key >= aKeyElement) continue;
                    aFrontier.add((Node)c.value);
                }
            }
            ArrayDeque aSwap = aFrontier;
            aFrontier = aNextFrontier;
            aNextFrontier = aSwap;
        }
        return aFrontier;
    }

    @Override
    public T getValue(Node<T> node) {
        return node.getValue();
    }

    @Override
    public void visitMinSupersets(long[] theKey, Consumer<Node<T>> theConsumer) {
        this.visitMinSupersets(this.getMatchingStartNodesWithPathLength(theKey), theConsumer);
    }

    private void visitMinSupersets(Collection<NodeWithPathLength<T>> theStartNodes, Consumer<Node<T>> theConsumer) {
        NodeWithPathLength aNext;
        ArrayDeque aToDo = Queues.newArrayDeque();
        ArrayList aSupersets = Lists.newArrayList();
        int aSize = Integer.MAX_VALUE;
        theStartNodes.forEach(aToDo::add);
        while ((aNext = (NodeWithPathLength)aToDo.poll()) != null) {
            if (aNext.node.getValue() != null) {
                if (aNext.pathLen > aSize) continue;
                aSize = aNext.pathLen;
                aSupersets.add(aNext.node);
                continue;
            }
            if (aNext.pathLen >= aSize) continue;
            for (LongObjectCursor c2 : aNext.node.getChildren()) {
                aToDo.add(new NodeWithPathLength((Node)c2.value, aNext.pathLen + 1));
            }
        }
        int aMinSize = aSize;
        aSupersets.forEach(c -> {
            if (c.getPath().length == aMinSize) {
                theConsumer.accept((Node)c);
            }
        });
    }

    private Collection<NodeWithPathLength<T>> getMatchingStartNodesWithPathLength(long[] key) {
        ArrayDeque aFrontier = Queues.newArrayDeque();
        ArrayDeque aNextFrontier = Queues.newArrayDeque();
        aFrontier.add(new NodeWithPathLength<T>(this.root, 0));
        for (int i = 0; i < key.length && !aFrontier.isEmpty(); ++i) {
            long aKeyElement = key[i];
            while (!aFrontier.isEmpty()) {
                NodeWithPathLength aNode = (NodeWithPathLength)aFrontier.poll();
                Node aNext = aNode.node.getChild(aKeyElement);
                if (aNext != null) {
                    aNextFrontier.add(new NodeWithPathLength(aNext, aNode.pathLen + 1));
                }
                for (LongObjectCursor c : aNode.node.getChildren()) {
                    if (c.key >= aKeyElement) continue;
                    aFrontier.add(new NodeWithPathLength((Node)c.value, aNode.pathLen + 1));
                }
            }
            ArrayDeque aSwap = aFrontier;
            aFrontier = aNextFrontier;
            aNextFrontier = aSwap;
        }
        return aFrontier;
    }

    @Override
    public void visitMaxSubsets(long[] theKey, Consumer<Node<T>> theConsumer) {
        Node aNext;
        ArrayDeque aToDo = Queues.newArrayDeque();
        ArrayList aSubsets = Lists.newArrayList();
        int aSize = 0;
        aToDo.push(this.root);
        while ((aNext = (Node)aToDo.poll()) != null) {
            if (aNext.getValue() != null && aNext.getPath().length >= aSize) {
                aSubsets.add(aNext);
                aSize = aNext.getPath().length;
            }
            for (LongObjectCursor c2 : aNext.getChildren()) {
                if (Arrays.binarySearch(theKey, c2.key) < 0) continue;
                aToDo.push((Node)c2.value);
            }
        }
        int aMaxSize = aSize;
        aSubsets.forEach(c -> {
            if (c.getPath().length == aMaxSize) {
                theConsumer.accept((Node)c);
            }
        });
    }

    @Override
    public void clear() {
        this.root.clear();
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long nodes() {
        return this.nodes;
    }

    @Override
    public void print(Writer writer) throws IOException {
        writer.write("Trie\n");
        writer.write("Root\n");
        this.print(this.root, writer, 0);
        writer.flush();
    }

    private void print(Node<T> node, Writer writer, int height) throws IOException {
        if (node.isObjectNode()) {
            writer.write("\t" + (node.getValue() != null ? node.getValue().toString() : "null") + "\n");
            if (node.getChildren() != null && node.getChildren().iterator().hasNext()) {
                this.indent(height, writer);
            }
        }
        int indent = 0;
        for (LongObjectCursor<Node<T>> childKey : node.getChildren()) {
            this.indent(indent, writer);
            writer.write("\t" + childKey.key);
            this.print(node.getChild(childKey.key), writer, height + 1);
            indent = height;
        }
    }

    protected static class PathToNode<T> {
        final Node<T> node;
        final List<Long> path;

        PathToNode(Node<T> theNode, List<Long> thePath) {
            this.node = theNode;
            this.path = thePath;
        }
    }

    private static class NodeWithPathLength<T> {
        final Node<T> node;
        final int pathLen;

        NodeWithPathLength(Node<T> theNode, int theLen) {
            this.node = theNode;
            this.pathLen = theLen;
        }
    }
}

