/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.trie;

import com.carrotsearch.hppc.LongObjectHashMap;
import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.complexible.common.trie.Node;
import com.complexible.common.trie.PrefixTree;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class RadixTree<T>
extends PrefixTree<T> {
    private final RadixNode<T> root = new RadixNode();
    private long size = 0L;
    private long nodes = 0L;

    public RadixTree() {
        this.root.setPath(new long[0]);
    }

    @Override
    public Node<T> getRoot() {
        return this.root;
    }

    @Override
    public boolean put(long[] key, T value) {
        Preconditions.checkNotNull(value);
        PathToNode<T> aSearchResult = this.search(key);
        RadixNode<T> aLastInTrie = aSearchResult.node;
        int pathLength = aSearchResult.path.size();
        if (aSearchResult.path.size() > 0 && key.length == aSearchResult.path.size() && aLastInTrie.lastInPath() == key[key.length - 1]) {
            if (aLastInTrie.getValue() != null && value.equals(aLastInTrie.getValue())) {
                return false;
            }
            if (!aLastInTrie.isObjectNode()) {
                ++this.size;
            }
            aLastInTrie.setValue(value);
            return true;
        }
        if (aLastInTrie.getSubPath().length == 0 || aLastInTrie.lastInPath() == aSearchResult.path.get(aSearchResult.path.size() - 1).longValue()) {
            int idx = aSearchResult.path.size();
            Node newNode = aLastInTrie.addChild(key[idx]);
            ++this.nodes;
            newNode.setValue(value);
            if (idx < key.length) {
                newNode.setPath(Arrays.copyOfRange(key, idx + 1, key.length));
            }
            ++this.size;
            return true;
        }
        RadixNode parent = (RadixNode)aLastInTrie.getParent();
        RadixNode<T> intermediateNode = new RadixNode<T>();
        ++this.nodes;
        int matchIdx = Arrays.binarySearch(aLastInTrie.getSubPath(), aSearchResult.path.get(pathLength - 1));
        if (matchIdx < 0) {
            intermediateNode.setPath(new long[0]);
        } else {
            intermediateNode.setPath(Arrays.copyOfRange(aLastInTrie.getSubPath(), 0, matchIdx + 1));
        }
        RadixNode<T> previousChild = aLastInTrie;
        long oldParentKey = previousChild.parentKey;
        intermediateNode.addChild(aLastInTrie.getSubPath()[matchIdx + 1], previousChild);
        previousChild.setPath(Arrays.copyOfRange(previousChild.getSubPath(), matchIdx + 2, previousChild.getSubPath().length));
        parent.addChild(oldParentKey, intermediateNode);
        if (aSearchResult.path.size() == key.length) {
            intermediateNode.setValue(value);
            ++this.size;
            return true;
        }
        Node newNode = intermediateNode.addChild(key[pathLength]);
        ++this.nodes;
        newNode.setValue(value);
        long[] newPath = Arrays.copyOfRange(key, pathLength + 1, key.length);
        newNode.setPath(newPath);
        ++this.size;
        return true;
    }

    @Override
    public T get(long[] key) {
        RadixNode<T> aNode = this.getNodeForValue(key);
        return aNode == null ? null : (T)aNode.getValue();
    }

    protected RadixNode<T> getNodeForValue(long[] key) {
        PathToNode<T> aLastInTrie = this.search(key);
        return aLastInTrie.path.size() == key.length ? aLastInTrie.node : null;
    }

    private PathToNode<T> search(long[] key) {
        int height;
        ArrayList aPath = Lists.newArrayList();
        RadixNode<T> aStart = this.root;
        RadixNode<T> aResult = null;
        key = this.normalize(key);
        long prevKey = -1L;
        for (height = 0; height < key.length && aStart != null; aStart = aStart.getChild(key[height], prevKey), ++height) {
            aResult = aStart;
            prevKey = key[height];
            aPath.add(key[height]);
        }
        if (aStart != null && (height == aPath.size() || aStart.lastInPath() == key[height - 1])) {
            return new PathToNode<T>(aStart, aPath);
        }
        aPath.remove(aPath.size() - 1);
        return new PathToNode<T>(aResult, aPath);
    }

    @Override
    public Collection<Node<T>> getMatchingStartNodes(long[] key) {
        ArrayDeque aFrontier = Queues.newArrayDeque();
        ArrayDeque aNextFrontier = Queues.newArrayDeque();
        aFrontier.add(this.root);
        for (int i = 0; i < key.length && !aFrontier.isEmpty(); ++i) {
            long aKeyElement = key[i];
            while (!aFrontier.isEmpty()) {
                RadixNode aNode = (RadixNode)aFrontier.poll();
                RadixNode aNext = aNode.getAnyChild(aKeyElement);
                if (aNext != null) {
                    aNextFrontier.add(aNext);
                }
                for (LongObjectCursor c : aNode.getChildren()) {
                    if (c.key >= aKeyElement) continue;
                    aFrontier.add((Node)c.value);
                }
            }
            ArrayDeque aSwap = aFrontier;
            aFrontier = aNextFrontier;
            aNextFrontier = aSwap;
        }
        return aFrontier;
    }

    private Collection<NodeWithPathLength<T>> getMatchingStartNodesWithPathLength(long[] key) {
        ArrayDeque aFrontier = Queues.newArrayDeque();
        ArrayDeque aNextFrontier = Queues.newArrayDeque();
        aFrontier.add(new NodeWithPathLength<T>(this.root, 0));
        for (int i = 0; i < key.length && !aFrontier.isEmpty(); ++i) {
            long aKeyElement = key[i];
            while (!aFrontier.isEmpty()) {
                NodeWithPathLength aNode = (NodeWithPathLength)aFrontier.poll();
                RadixNode aNext = aNode.node.getAnyChild(aKeyElement);
                if (aNext != null) {
                    int pathLength = 0;
                    if (aNext != aNode.node) {
                        pathLength += aNode.node.path.length + 1;
                    }
                    if (i < key.length - 1) {
                        aNextFrontier.add(new NodeWithPathLength(aNext, aNode.pathLen + pathLength));
                    } else {
                        aNextFrontier.add(new NodeWithPathLength(aNext, aNode.pathLen + pathLength + aNext.path.length));
                    }
                }
                for (LongObjectCursor c : aNode.node.getChildren()) {
                    if (c.key >= aKeyElement) continue;
                    aFrontier.add(new NodeWithPathLength((RadixNode)c.value, aNode.pathLen + aNode.node.path.length + 1));
                }
            }
            ArrayDeque aSwap = aFrontier;
            aFrontier = aNextFrontier;
            aNextFrontier = aSwap;
        }
        return aFrontier;
    }

    @Override
    public void visitMinSupersets(long[] theKey, Consumer<Node<T>> theConsumer) {
        this.visitMinSupersets(this.getMatchingStartNodesWithPathLength(theKey), theConsumer);
    }

    @Override
    public void visitMaxSubsets(long[] theKey, Consumer<Node<T>> theConsumer) {
        NodeWithPathLength aNext;
        ArrayDeque aToDo = Queues.newArrayDeque();
        ArrayList aSubsets = Lists.newArrayList();
        int aSize = 0;
        aToDo.push(new NodeWithPathLength<T>(this.root, 0));
        while ((aNext = (NodeWithPathLength)aToDo.poll()) != null) {
            if (aNext.node.value != null && Arrays.stream(aNext.node.getSubPath()).allMatch(key -> Arrays.binarySearch(theKey, key) >= 0) && aNext.pathLen >= aSize) {
                aSubsets.add(aNext);
                aSize = aNext.pathLen;
            }
            for (LongObjectCursor c2 : aNext.node.getChildren()) {
                if (Arrays.binarySearch(theKey, c2.key) < 0) continue;
                RadixNode value = (RadixNode)c2.value;
                aToDo.push(new NodeWithPathLength(value, aNext.pathLen + aNext.node.getSubPath().length + value.getSubPath().length + 1));
            }
        }
        int aMaxSize = aSize;
        aSubsets.forEach(c -> {
            if (c.pathLen == aMaxSize) {
                theConsumer.accept(c.node);
            }
        });
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long nodes() {
        return this.nodes;
    }

    private void visitMinSupersets(Collection<NodeWithPathLength<T>> theStartNodes, Consumer<Node<T>> theConsumer) {
        NodeWithPathLength aNext;
        ArrayDeque aToDo = Queues.newArrayDeque();
        ArrayList aSupersets = Lists.newArrayList();
        int aSize = Integer.MAX_VALUE;
        theStartNodes.forEach(aToDo::add);
        while ((aNext = (NodeWithPathLength)aToDo.poll()) != null) {
            if (aNext.node.value != null) {
                if (aNext.pathLen > aSize) continue;
                aSize = aNext.pathLen;
                aSupersets.add(aNext);
                continue;
            }
            if (aNext.pathLen >= aSize) continue;
            for (LongObjectCursor c2 : aNext.node.getChildren()) {
                RadixNode node = (RadixNode)c2.value;
                aToDo.add(new NodeWithPathLength(node, aNext.pathLen + 1 + node.getSubPath().length));
            }
        }
        int aMinSize = aSize;
        aSupersets.forEach(c -> {
            if (c.pathLen == aMinSize) {
                theConsumer.accept(c.node);
            }
        });
    }

    @Override
    public void print(Writer writer) throws IOException {
        writer.write("RadixTree\n");
        writer.write("Root\n");
        this.print(this.root, writer, 0);
        writer.flush();
    }

    private void print(Node<T> node, Writer writer, int height) throws IOException {
        if (node.isObjectNode()) {
            writer.write("\t" + (node.getValue() != null ? node.getValue().toString() : "null") + "\n");
            if (node.getChildren() != null && node.getChildren().iterator().hasNext()) {
                this.indent(height, writer);
            }
        }
        int indent = 0;
        for (LongObjectCursor<Node<T>> childKey : node.getChildren()) {
            this.indent(indent, writer);
            writer.write("\t" + childKey.key);
            this.print(node.getChild(childKey.key), writer, height + 1);
            indent = height;
        }
    }

    public static class RadixNode<T>
    extends Node<T> {
        protected long[] path = null;
        private RadixNode<T> parent = null;
        private long parentKey = -1L;

        @Override
        RadixNode<T> addChild(long key) {
            if (this.children == null) {
                this.children = new LongObjectHashMap();
            }
            RadixNode<T> aChild = new RadixNode<T>();
            aChild.setParent(this, key);
            this.children.put(key, aChild);
            return aChild;
        }

        RadixNode<T> addChild(long key, RadixNode<T> theChild) {
            if (this.children == null) {
                this.children = new LongObjectHashMap();
            }
            theChild.setParent(this, key);
            this.children.put(key, theChild);
            return theChild;
        }

        private void setParent(RadixNode<T> theParent, long theParentKey) {
            this.parent = theParent;
            this.parentKey = theParentKey;
        }

        RadixNode<T> getChild(long key, long previousKey) {
            if (this.path.length == 0 || previousKey == this.path[this.path.length - 1]) {
                return this.children == null ? null : (RadixNode)this.children.get(key);
            }
            int i = Arrays.binarySearch(this.path, previousKey);
            if (i + 1 < this.path.length && this.path[i + 1] == key) {
                return this;
            }
            return null;
        }

        RadixNode<T> getAnyChild(long key) {
            RadixNode<T> child;
            RadixNode<T> radixNode = child = this.children == null ? null : (RadixNode<T>)this.children.get(key);
            return child != null ? child : (Arrays.binarySearch(this.path, key) >= 0 ? this : null);
        }

        private List<Long> getFullPath(List<Long> thePath) {
            if (this.parent == null) {
                Collections.reverse(thePath);
                return thePath;
            }
            for (int i = this.path.length - 1; i >= 0; --i) {
                thePath.add(this.path[i]);
            }
            thePath.add(this.parentKey);
            return this.parent.getFullPath(thePath);
        }

        List<Long> getFullPath() {
            return this.getFullPath(new ArrayList<Long>());
        }

        long[] getSubPath() {
            return this.path;
        }

        @Override
        public long[] getPath() {
            return this.getFullPath().stream().mapToLong(l -> l).toArray();
        }

        @Override
        void setPath(long[] path) {
            this.path = path;
        }

        long lastInPath() {
            return this.path.length > 0 ? this.path[this.path.length - 1] : this.parentKey;
        }

        Node<T> getParent() {
            return this.parent;
        }
    }

    private static class PathToNode<T> {
        final RadixNode<T> node;
        final List<Long> path;

        PathToNode(RadixNode<T> theNode, List<Long> thePath) {
            this.node = theNode;
            this.path = thePath;
        }
    }

    private static class NodeWithPathLength<T> {
        final RadixNode<T> node;
        final int pathLen;

        NodeWithPathLength(RadixNode<T> theNode, int theLen) {
            this.node = theNode;
            this.pathLen = theLen;
        }
    }
}

