/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.primitives;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.util.BitSet;

public final class Serializers {
    public static final IntSerializer INT = new IntSerializer();
    public static final LongSerializer LONG = new LongSerializer();
    public static final LittleEndianLongSerializer LITTLE_LONG = new LittleEndianLongSerializer();
    public static final UnsignedLongSerializer UNSIGNED_LONG = new UnsignedLongSerializer();
    public static final VarLongSerializer VAR_LONG = new VarLongSerializer();
    public static final ShortSerializer SHORT = new ShortSerializer();
    public static final ObjectSerializer<String> STRING = new ObjectSerializer<String>(){

        @Override
        public byte[] serialize(String value) {
            return value.getBytes(Charsets.UTF_8);
        }

        @Override
        public int serialize(String value, byte[] bytes, int offset) {
            byte[] result = this.serialize(value);
            System.arraycopy(result, 0, bytes, offset, result.length);
            return result.length;
        }

        @Override
        public String deserialize(byte[] bytes) {
            return new String(bytes, Charsets.UTF_8);
        }

        @Override
        public String deserialize(byte[] bytes, int offset, int length) {
            return new String(bytes, offset, length, Charsets.UTF_8);
        }
    };
    public static final ObjectSerializer<IntArrayList> INT_ARRAY = new ObjectSerializer<IntArrayList>(){

        @Override
        public byte[] serialize(IntArrayList value) {
            byte[] bytes = new byte[value.size() * 4];
            this.serialize(value, bytes, 0);
            return bytes;
        }

        @Override
        public int serialize(IntArrayList value, byte[] bytes, int offset) {
            for (IntCursor cursor : value) {
                INT.serialize(cursor.value, bytes, offset);
                offset += 4;
            }
            return value.size() * 4;
        }

        @Override
        public IntArrayList deserialize(byte[] bytes) {
            return this.deserialize(bytes, 0, bytes.length);
        }

        @Override
        public IntArrayList deserialize(byte[] bytes, int offset, int length) {
            int count = length / 4;
            IntArrayList result = new IntArrayList();
            for (int i = 0; i < count; ++i) {
                result.add(INT.deserialize(bytes, offset));
                offset += 4;
            }
            return result;
        }
    };
    public static final ObjectSerializer<BitSet> BIT_SET = new ObjectSerializer<BitSet>(){
        protected int[] BIT_MASK = new int[]{128, 64, 32, 16, 8, 4, 2, 1};

        protected boolean isBitOn(int bit, byte[] bytes) {
            return (bytes[bit >> 3] & this.BIT_MASK[bit & 7]) != 0;
        }

        protected void setBit(int bit, byte[] bytes) {
            int n = bit >> 3;
            bytes[n] = (byte)(bytes[n] | this.BIT_MASK[bit & 7]);
        }

        protected int bytesRequired(BitSet value) {
            return value.isEmpty() ? 0 : (value.length() - 1) / 8 + 1;
        }

        @Override
        public byte[] serialize(BitSet value) {
            int n = this.bytesRequired(value);
            byte[] bytes = new byte[n];
            this._serialize(value, bytes, 0);
            return bytes;
        }

        @Override
        public int serialize(BitSet value, byte[] bytes, int offset) {
            int n = this.bytesRequired(value);
            this._serialize(value, bytes, offset);
            return n;
        }

        protected void _serialize(BitSet value, byte[] bytes, int offset) {
            int bitOffset = offset * 8;
            for (int i = 0; i < value.length(); ++i) {
                if (!value.get(i)) continue;
                this.setBit(bitOffset + i, bytes);
            }
        }

        @Override
        public BitSet deserialize(byte[] bytes) {
            return this.deserialize(bytes, 0, bytes.length);
        }

        @Override
        public BitSet deserialize(byte[] bytes, int offset, int length) {
            int bitOffset = offset * 8;
            BitSet result = new BitSet();
            for (int i = 0; i < length * 8; ++i) {
                if (!this.isBitOn(bitOffset + i, bytes)) continue;
                result.set(i);
            }
            return result;
        }
    };

    private Serializers() {
        throw new AssertionError();
    }

    public static void main(String ... args) throws Exception {
        byte[] b = LITTLE_LONG.serialize(384L);
        System.out.println(LITTLE_LONG.deserialize(b));
    }

    public static final class LittleEndianLongSerializer {
        public byte[] serialize(long value) {
            byte[] bytes = new byte[8];
            bytes[7] = (byte)(value >>> 56);
            bytes[6] = (byte)(value >>> 48);
            bytes[5] = (byte)(value >>> 40);
            bytes[4] = (byte)(value >>> 32);
            bytes[3] = (byte)(value >>> 24);
            bytes[2] = (byte)(value >>> 16);
            bytes[1] = (byte)(value >>> 8);
            bytes[0] = (byte)value;
            return bytes;
        }

        public void serialize(long value, byte[] bytes, int offset) {
            bytes[offset + 7] = (byte)(value >>> 56);
            bytes[offset + 6] = (byte)(value >>> 48);
            bytes[offset + 5] = (byte)(value >>> 40);
            bytes[offset + 4] = (byte)(value >>> 32);
            bytes[offset + 3] = (byte)(value >>> 24);
            bytes[offset + 2] = (byte)(value >>> 16);
            bytes[offset + 1] = (byte)(value >>> 8);
            bytes[offset] = (byte)value;
        }

        public long deserialize(byte[] bytes) {
            return this.deserialize(bytes, 0);
        }

        public long deserialize(byte[] bytes, int offset) {
            return (long)bytes[offset + 7] << 56 | ((long)bytes[offset + 6] & 0xFFL) << 48 | ((long)bytes[offset + 5] & 0xFFL) << 40 | ((long)bytes[offset + 4] & 0xFFL) << 32 | ((long)bytes[offset + 3] & 0xFFL) << 24 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 1] & 0xFFL) << 8 | (long)bytes[offset] & 0xFFL;
        }
    }

    public static final class IntSerializer {
        public byte[] serialize(int value) {
            byte[] bytes = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
            return bytes;
        }

        public void serialize(int value, byte[] bytes, int offset) throws ArrayIndexOutOfBoundsException {
            bytes[offset++] = (byte)(value >> 24);
            bytes[offset++] = (byte)(value >> 16);
            bytes[offset++] = (byte)(value >> 8);
            bytes[offset] = (byte)value;
        }

        public int deserialize(byte[] bytes) throws ArrayIndexOutOfBoundsException {
            return (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
        }

        public int deserialize(byte[] bytes, int offset) {
            return (bytes[offset++] & 0xFF) << 24 | (bytes[offset++] & 0xFF) << 16 | (bytes[offset++] & 0xFF) << 8 | bytes[offset] & 0xFF;
        }
    }

    public static final class LongSerializer {
        public byte[] serialize(long value) {
            byte[] bytes = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)(value >>> 0)};
            return bytes;
        }

        public void serialize(long value, byte[] bytes, int offset) {
            bytes[offset++] = (byte)(value >>> 56);
            bytes[offset++] = (byte)(value >>> 48);
            bytes[offset++] = (byte)(value >>> 40);
            bytes[offset++] = (byte)(value >>> 32);
            bytes[offset++] = (byte)(value >>> 24);
            bytes[offset++] = (byte)(value >>> 16);
            bytes[offset++] = (byte)(value >>> 8);
            bytes[offset] = (byte)(value >>> 0);
        }

        public long deserialize(byte[] bytes) {
            return ((long)bytes[0] << 56) + ((long)(bytes[1] & 0xFF) << 48) + ((long)(bytes[2] & 0xFF) << 40) + ((long)(bytes[3] & 0xFF) << 32) + ((long)(bytes[4] & 0xFF) << 24) + (long)((bytes[5] & 0xFF) << 16) + (long)((bytes[6] & 0xFF) << 8) + (long)((bytes[7] & 0xFF) << 0);
        }

        public long deserialize(byte[] bytes, int offset) {
            return ((long)bytes[offset + 0] << 56) + ((long)(bytes[offset + 1] & 0xFF) << 48) + ((long)(bytes[offset + 2] & 0xFF) << 40) + ((long)(bytes[offset + 3] & 0xFF) << 32) + ((long)(bytes[offset + 4] & 0xFF) << 24) + (long)((bytes[offset + 5] & 0xFF) << 16) + (long)((bytes[offset + 6] & 0xFF) << 8) + (long)((bytes[offset + 7] & 0xFF) << 0);
        }
    }

    public static final class UnsignedLongSerializer {
        private final long SHIFT = Math.abs(Long.MIN_VALUE);

        public byte[] serialize(long value) {
            return LONG.serialize(value + this.SHIFT);
        }

        public void serialize(long value, byte[] bytes, int offset) {
            LONG.serialize(value + this.SHIFT, bytes, offset);
        }

        public long deserialize(byte[] bytes) {
            return LONG.deserialize(bytes) - this.SHIFT;
        }

        public long deserialize(byte[] bytes, int offset) {
            return LONG.deserialize(bytes, offset) - this.SHIFT;
        }
    }

    public static final class VarLongSerializer {
        public int bytesRequired(long value) {
            return 8 - (Long.numberOfLeadingZeros(value) >> 3);
        }

        public byte[] serialize(long value) {
            int bytesRequired = this.bytesRequired(value);
            byte[] bytes = new byte[bytesRequired];
            int i = bytesRequired - 1;
            while (i >= 0) {
                bytes[i] = (byte)value;
                --i;
                value >>>= 8;
            }
            return bytes;
        }

        public int serialize(long value, byte[] bytes, int offset) {
            int bytesRequired = this.bytesRequired(value);
            int i = offset + bytesRequired - 1;
            while (i >= offset) {
                bytes[i] = (byte)value;
                --i;
                value >>>= 8;
            }
            return bytesRequired;
        }

        public long deserialize(byte[] bytes) {
            return this.deserialize(bytes, 0, bytes.length);
        }

        public long deserialize(byte[] bytes, int offset, int length) {
            long value = 0L;
            int n = offset + length;
            for (int i = offset; i < n; ++i) {
                value <<= 8;
                value |= (long)(bytes[i] & 0xFF);
            }
            return value;
        }

        public long deserialize(ByteBuffer bytes, int offset, int length) {
            long value = 0L;
            int n = offset + length;
            for (int i = offset; i < n; ++i) {
                value <<= 8;
                value |= (long)(bytes.get(i) & 0xFF);
            }
            return value;
        }
    }

    public static final class ShortSerializer {
        public byte[] serialize(short value) {
            byte[] bytes = new byte[4];
            bytes[0] = (byte)(value >> 8);
            bytes[1] = (byte)value;
            return bytes;
        }

        public void serialize(short value, byte[] bytes, int offset) {
            bytes[offset] = (byte)(value >> 8);
            bytes[offset + 1] = (byte)value;
        }

        public short deserialize(byte[] bytes) {
            return (short)((bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF);
        }

        public short deserialize(byte[] bytes, int offset) {
            return (short)((bytes[offset++] & 0xFF) << 8 | bytes[offset] & 0xFF);
        }
    }

    public static interface ObjectSerializer<T> {
        public byte[] serialize(T var1);

        public int serialize(T var1, byte[] var2, int var3);

        public T deserialize(byte[] var1);

        public T deserialize(byte[] var1, int var2, int var3);
    }
}

