/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.primitives;

public final class Bits {
    private Bits() {
        throw new AssertionError();
    }

    public static boolean isSet(long theLong, int theIndex) {
        long aMask = Bits.bitMask(theIndex);
        return (theLong & aMask) != 0L;
    }

    public static long setBits(long theLong, int theStartBit, int theEndBit) {
        long aMask = Bits.bitMask(theStartBit, theEndBit);
        return theLong | aMask;
    }

    public static long setBits(long theLong, long theBits, int theStartBit, int theEndBit) {
        long aMask = Bits.bitMask(theStartBit, theEndBit);
        theLong = Bits.clearBits(theLong, theStartBit, theEndBit);
        return theLong |= theBits << theStartBit & aMask;
    }

    public static long extractBits(long theLong, int theStartBit, int theEndBit) {
        if (theEndBit == 0) {
            return 0L;
        }
        return theLong << 64 - theEndBit >>> 64 - theEndBit + theStartBit;
    }

    public static long clearBits(long theLong, int theStartBit, int theEndBit) {
        long aMask = Bits.zeroBitMask(theStartBit, theEndBit);
        return theLong &= aMask;
    }

    private static final long bitMask(int bitIndex) {
        return 1L << bitIndex;
    }

    public static long bitMask(int theStartBit, int theEndBit) {
        if (theEndBit == 0) {
            return 0L;
        }
        long aMask = -1L;
        return aMask << 64 - theEndBit >>> 64 - theEndBit + theStartBit << theStartBit;
    }

    private static long zeroBitMask(int theStartBit, int theEndBit) {
        return Bits.bitMask(theStartBit, theEndBit) ^ 0xFFFFFFFFFFFFFFFFL;
    }
}

