/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.primitives;

import com.complexible.common.collect.ArrayIterator;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.PeekingIterator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;

public final class ArrayUtil {
    public static final int SIZE_INCREASE = 2;
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private ArrayUtil() {
        throw new AssertionError();
    }

    public static <T> PeekingIterator<T> iterator(T[] theArray, int theStart, int theEnd) {
        return new ArrayIterator<T>(theArray, theStart, theEnd);
    }

    public static <T> PeekingIterator<T> iterator(T[] theArray) {
        return ArrayUtil.iterator(theArray, 0, theArray.length);
    }

    public static <T> int search(T[] theArray, T theObject, int theStart, int theEnd, Comparator<T> theComparator) {
        if (theComparator == null) {
            return Arrays.binarySearch(theArray, theStart, theEnd, theObject);
        }
        return Arrays.binarySearch(theArray, theStart, theEnd, theObject, theComparator);
    }

    public static <T> int search(T[] theArray, T theObject, Comparator<T> theComparator) {
        return ArrayUtil.search(theArray, theObject, 0, theArray.length, theComparator);
    }

    public static <T> int searchAfter(T[] theArray, T theObject, Comparator<T> theComparator) {
        int pos = ArrayUtil.search(theArray, theObject, theComparator);
        if (pos < 0) {
            pos = ArrayUtil.normalizeAfter(pos);
        }
        return pos;
    }

    public static <T> int searchAfter(T[] theArray, T theObject, int theStart, int theEnd, Comparator<T> theComparator) {
        int pos = ArrayUtil.search(theArray, theObject, theStart, theEnd, theComparator);
        if (pos < 0) {
            pos = ArrayUtil.normalizeAfter(pos);
        }
        return pos;
    }

    public static <T> int deferredEqualityBinarySearch(T[] theData, T theElement, int theStart, int theEnd, Comparator<T> theComparator) {
        int min = theStart;
        int max = theEnd;
        while (min < max) {
            int mid = min + max >>> 1;
            if (theComparator.compare(theData[mid], theElement) < 0) {
                min = mid + 1;
                continue;
            }
            max = mid;
        }
        if (max == min && min < theEnd && theComparator.compare(theData[min], theElement) == 0) {
            return min;
        }
        return -(min + 1);
    }

    public static <T> int deferredEqualityBinarySearchAfter(T[] theData, T theElement, int theStart, int theEnd, Comparator<T> theComparator) {
        int pos = ArrayUtil.deferredEqualityBinarySearch(theData, theElement, theStart, theEnd, theComparator);
        if (pos < 0) {
            pos = ArrayUtil.normalizeAfter(pos);
        }
        return pos;
    }

    public static <T> int deferredEqualityBinarySearchBefore(T[] theData, T theElement, Comparator<T> theComparator) {
        return ArrayUtil.deferredEqualityBinarySearchBefore(theData, theElement, 0, theData.length, theComparator);
    }

    public static <T> int deferredEqualityBinarySearchBefore(T[] theData, T theElement, int theStart, int theEnd, Comparator<T> theComparator) {
        int pos = ArrayUtil.deferredEqualityBinarySearch(theData, theElement, theStart, theEnd, theComparator);
        if (pos < 0) {
            pos = ArrayUtil.normalizeBefore(pos);
        }
        return pos;
    }

    public static <T> int searchBefore(T[] theArray, T theObject, Comparator<T> theComparator) {
        int pos = ArrayUtil.search(theArray, theObject, theComparator);
        if (pos < 0) {
            pos = ArrayUtil.normalizeBefore(pos);
        }
        return pos;
    }

    public static <T> int searchBefore(T[] theArray, T theObject, int theStart, int theEnd, Comparator<T> theComparator) {
        int pos = ArrayUtil.search(theArray, theObject, theStart, theEnd, theComparator);
        if (pos < 0) {
            pos = ArrayUtil.normalizeBefore(pos);
        }
        return pos;
    }

    public static <T> T[] copyOf(T[] theArray) {
        return ArrayUtil.copyOf(theArray, theArray.length);
    }

    public static int normalizeAfter(int thePosition) {
        return (thePosition + 1) * -1;
    }

    public static int normalizeBefore(int thePosition) {
        return Math.max(0, (thePosition + 2) * -1);
    }

    public static <T> T[] increaseSize(T[] theArray) {
        int newSize = theArray.length == 0 ? 2 : theArray.length * 2;
        return ArrayUtil.copyOf(theArray, newSize);
    }

    public static <T> T[] ensureSize(T[] theArray, int newSize) {
        return newSize < theArray.length ? theArray : ArrayUtil.copyOf(theArray, Math.max(newSize + 1, theArray.length * 2));
    }

    public static <T> T[] copyOf(T[] theArray, int theLength) {
        return Arrays.copyOf(theArray, theLength);
    }

    public static long[] copyOf(long[] theArray) {
        return ArrayUtil.copyOf(theArray, theArray.length);
    }

    public static long[] copyOf(long[] theArray, int theLength) {
        return Arrays.copyOf(theArray, theLength);
    }

    public static int[] copyOf(int[] theArray) {
        return ArrayUtil.copyOf(theArray, theArray.length);
    }

    public static int[] copyOf(int[] theArray, int theLength) {
        return Arrays.copyOf(theArray, theLength);
    }

    public static <T> T[] newArray(int theLength) {
        return new Object[theLength];
    }

    public static int sequentialSearch(long[] theArray, int theSize, long theElement) {
        for (int i = 0; i < theSize; ++i) {
            if (theArray[i] != theElement) continue;
            return i;
        }
        return -1;
    }

    public static <T> int sequentialSearch(T[] theArray, T theElement) {
        return ArrayUtil.sequentialSearch(theArray, theArray.length, theElement);
    }

    public static <T> int sequentialSearch(T[] theArray, int theSize, T theElement) {
        for (int i = 0; i < theSize; ++i) {
            if (!theArray[i].equals(theElement)) continue;
            return i;
        }
        return -1;
    }

    public static <T> void sort(T[] theArray, int theStart, int theEnd, Comparator<? super T> theComparator) {
        Arrays.sort(theArray, theStart, theEnd, theComparator);
    }

    public static boolean isSorted(long[] theArray) {
        for (int i = 1; i < theArray.length; ++i) {
            long e1 = theArray[i - 1];
            long e2 = theArray[i];
            if (e1 <= e2) continue;
            return false;
        }
        return true;
    }

    public static <T> void sort(T[] theArray, Comparator<T> theComparator) {
        ArrayUtil.sort(theArray, 0, theArray.length, theComparator);
    }

    public static byte[] merge(byte[] theFirst, byte[] theSecond) {
        byte[] data = new byte[theFirst.length + theSecond.length];
        System.arraycopy(theFirst, 0, data, 0, theFirst.length);
        System.arraycopy(theSecond, 0, data, theFirst.length, theSecond.length);
        return data;
    }

    public static long[] merge(long[] theFirst, long[] theSecond) {
        long[] aResult = new long[theFirst.length + theSecond.length];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < theFirst.length && j < theSecond.length) {
            long t;
            long l = t = theFirst[i] < theSecond[j] ? theFirst[i++] : theSecond[j++];
            while (i < theFirst.length && theFirst[i] == t) {
                ++i;
            }
            while (j < theSecond.length && theSecond[j] == t) {
                ++j;
            }
            aResult[k++] = t;
        }
        while (i < theFirst.length) {
            aResult[k++] = theFirst[i++];
        }
        while (j < theSecond.length) {
            aResult[k++] = theSecond[j++];
        }
        return k >= aResult.length ? aResult : Arrays.copyOf(aResult, k);
    }

    public static <T> int removeDuplicates(T[] theSortedArray, int theSize) {
        int i;
        if (theSize <= 1) {
            return theSize;
        }
        for (i = 0; i < theSize - 1 && !theSortedArray[i].equals(theSortedArray[i + 1]); ++i) {
        }
        for (int j = i + 1; j < theSize; ++j) {
            if (theSortedArray[i].equals(theSortedArray[j])) continue;
            theSortedArray[++i] = theSortedArray[j];
        }
        return i + 1;
    }

    public static <T> int removeDuplicates(T[] theSortedArray, int theSize, Comparator<T> theComparator) {
        int i;
        if (theSize <= 1) {
            return theSize;
        }
        for (i = 0; i < theSize - 1 && !theSortedArray[i].equals(theSortedArray[i + 1]); ++i) {
        }
        for (int j = i + 1; j < theSize; ++j) {
            if (theComparator.compare(theSortedArray[i], theSortedArray[j]) == 0) continue;
            theSortedArray[++i] = theSortedArray[j];
        }
        return i + 1;
    }

    public static <T> int merge(T[] theFirstArray, int theFirstSize, T[] theSecondArray, int theSecondSize, T[] theResult, Comparator<T> theComparator) {
        if (theFirstSize / 2 > theSecondSize) {
            return ArrayUtil.mergeSmallIntoLarge(theFirstArray, theFirstSize, theSecondArray, theSecondSize, theResult, theComparator);
        }
        if (theFirstSize * 2 < theSecondArray.length) {
            return ArrayUtil.mergeSmallIntoLarge(theSecondArray, theSecondSize, theFirstArray, theFirstSize, theResult, theComparator);
        }
        return ArrayUtil.mergeEqual(theFirstArray, theFirstSize, theSecondArray, theSecondSize, theResult, theComparator);
    }

    private static <T> int mergeEqual(T[] theSortedArray, int theSize, T[] theElements, int theElementsSize, T[] theResult, Comparator<T> theComparator) {
        int firstPos = 0;
        int secondPos = 0;
        int count = 0;
        Object previous = null;
        while (firstPos < theSize && secondPos < theElementsSize) {
            T triple;
            int comp = theComparator.compare(theSortedArray[firstPos], theElements[secondPos]);
            if (comp < 0) {
                triple = theSortedArray[firstPos++];
            } else if (comp == 0) {
                triple = theSortedArray[firstPos++];
                ++secondPos;
            } else {
                triple = theElements[secondPos++];
            }
            if (previous != null && theComparator.compare(triple, previous) == 0) continue;
            theResult[count++] = triple;
            previous = triple;
        }
        if (firstPos < theSize) {
            System.arraycopy(theSortedArray, firstPos, theResult, count, theSize - firstPos);
            count += theSize - firstPos;
        } else {
            System.arraycopy(theElements, secondPos, theResult, count, theElementsSize - secondPos);
            count += theElementsSize - secondPos;
        }
        return count;
    }

    private static <T> int mergeSmallIntoLarge(T[] theSortedArray, int theSize, T[] theElements, int theElementsSize, T[] theResult, Comparator<T> theComparator) {
        int lastInsertionPos = 0;
        int insertionCount = 0;
        for (int i = 0; i < theElementsSize; ++i) {
            int pos;
            if (i > 0 && theComparator.compare(theElements[i], theElements[i - 1]) == 0 || (pos = ArrayUtil.search(theSortedArray, theElements[i], 0, theSize, theComparator)) >= 0) continue;
            int insertionPos = ArrayUtil.normalizeAfter(pos);
            int blockLength = insertionPos - lastInsertionPos;
            System.arraycopy(theSortedArray, lastInsertionPos, theResult, lastInsertionPos + insertionCount, blockLength);
            theResult[insertionPos + insertionCount++] = theElements[i];
            lastInsertionPos = insertionPos;
        }
        if (lastInsertionPos < theSize) {
            System.arraycopy(theSortedArray, lastInsertionPos, theResult, lastInsertionPos + insertionCount, theSize - lastInsertionPos);
        }
        return theSize + insertionCount;
    }

    public static <T> void delete(T[] data, int size, int pos) {
        data[pos] = null;
        int length = size - pos - 1;
        if (length > 0) {
            System.arraycopy(data, pos + 1, data, pos, length);
        }
    }

    public static <T> void delete(long[] data, int size, int pos) {
        data[pos] = 0L;
        int length = size - pos - 1;
        if (length > 0) {
            System.arraycopy(data, pos + 1, data, pos, length);
        }
    }

    public static <T> T[] insert(T[] data, int size, int pos, T theElement) {
        T[] aNewData = data;
        if (size >= data.length) {
            aNewData = ArrayUtil.increaseSize(data);
        }
        if (pos < size) {
            System.arraycopy(data, pos, aNewData, pos + 1, size - pos);
        }
        aNewData[pos] = theElement;
        return aNewData;
    }

    public static long[] insert(long[] data, int size, int pos, long theElement) {
        long[] aNewData = data;
        if (size >= data.length) {
            aNewData = new long[(data.length + 1) * 2];
            System.arraycopy(data, 0, aNewData, 0, pos);
        }
        if (pos < size) {
            System.arraycopy(data, pos, aNewData, pos + 1, size - pos);
        }
        aNewData[pos] = theElement;
        return aNewData;
    }

    public static boolean rangeEquals(byte[] bytes1, int offset1, byte[] bytes2, int offset2, int length) {
        int o1 = offset1 + length - 1;
        int o2 = offset2 + length - 1;
        while (o1 >= offset1) {
            if (bytes1[o1] != bytes2[o2]) {
                return false;
            }
            --o1;
            --o2;
        }
        return true;
    }

    public static <T> T onlyMatch(T[] array, Predicate<T> predicate) {
        return (T)StreamSupport.stream(Arrays.spliterator(array), false).filter(predicate).collect(MoreCollectors.onlyElement());
    }
}

