/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.pool;

import com.complexible.common.pool.Pool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolUtils;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class ApachePoolImpl<T>
implements Pool<T, Exception> {
    private final GenericObjectPool<T> mPool;

    public ApachePoolImpl(PoolableObjectFactory<T> theFactory, int theMin, GenericObjectPool.Config theConfig) {
        GenericObjectPool aPool = new GenericObjectPool(theFactory, theConfig);
        try {
            PoolUtils.prefill((ObjectPool)aPool, (int)theMin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mPool = aPool;
    }

    @Override
    public T obtain() throws Exception {
        return (T)this.mPool.borrowObject();
    }

    @Override
    public void shutdown() throws Exception {
        this.mPool.setMinEvictableIdleTimeMillis(1L);
        this.mPool.setMaxIdle(0);
        this.mPool.setMaxActive(0);
        Thread.sleep(1L);
        this.mPool.evict();
        this.mPool.close();
    }

    @Override
    public void release(T theObj) throws Exception {
        this.mPool.returnObject(theObj);
    }
}

