/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.nio;

import com.complexible.common.base.Maths;
import com.complexible.common.unsafe.UnsafeUtil;
import com.google.common.base.Preconditions;
import com.google.common.math.IntMath;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBuffers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteBuffers.class);
    public static final boolean ADDRESS_AVAILABLE;
    private static final long NIO_BUFFER_ADDRESS_FIELD_OFFSET;

    @SuppressForbidden
    public static ByteBuffer allocate(int capacity, ByteOrder order) {
        return ByteBuffer.allocate(capacity).order(order);
    }

    @SuppressForbidden
    public static ByteBuffer wrap(byte[] array, ByteOrder order) {
        return ByteBuffer.wrap(array).order(order);
    }

    @SuppressForbidden
    public static ByteBuffer wrap(byte[] array, int offset, int length, ByteOrder order) {
        return ByteBuffer.wrap(array, offset, length).order(order);
    }

    @SuppressForbidden
    public static ByteBuffer allocateDirect(int capacity, ByteOrder order) {
        return ByteBuffer.allocateDirect(capacity).order(order);
    }

    @SuppressForbidden
    public static MappedByteBuffer map(FileChannel channel, FileChannel.MapMode mode, long position, long size, ByteOrder order) throws IOException {
        MappedByteBuffer buffer = channel.map(mode, position, size);
        buffer.order(order);
        return buffer;
    }

    @SuppressForbidden
    public static ByteBuffer slice(ByteBuffer toSlice) {
        return toSlice.slice().order(toSlice.order());
    }

    @SuppressForbidden
    public static ByteBuffer duplicate(ByteBuffer toDuplicate) {
        return toDuplicate.duplicate().order(toDuplicate.order());
    }

    @SuppressForbidden
    public static ByteBuffer asReadOnlyBuffer(ByteBuffer source) {
        return source.asReadOnlyBuffer().order(source.order());
    }

    private static long getFieldOffset(ByteBuffer directBuffer, String fieldName) {
        try {
            return ByteBuffers.getFieldOffset(directBuffer.getClass(), fieldName);
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to get the offset of the '{}' field of direct ByteBuffer", (Object)fieldName, (Object)t);
            return 0L;
        }
    }

    private static boolean verifyAddressAccessibility(ByteBuffer directBuffer) {
        if (NIO_BUFFER_ADDRESS_FIELD_OFFSET == 0L) {
            return false;
        }
        try {
            if (ByteBuffers.getAddressInternal(directBuffer) != 0L) {
                return true;
            }
            LOGGER.warn("The address of a direct ByteBuffer is strangely 0");
            return false;
        }
        catch (Throwable t) {
            LOGGER.warn("Unable to read the address of a direct ByteBuffer", t);
            return false;
        }
    }

    private static long getFieldOffset(Class<?> clazz, String fieldName) {
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            try {
                return UnsafeUtil.UNSAFE.objectFieldOffset(c.getDeclaredField(fieldName));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new IllegalStateException("Field " + fieldName + " is not found in " + String.valueOf(clazz));
    }

    public static long getAddress(ByteBuffer b) {
        if (!b.isDirect()) {
            throw new IllegalArgumentException("Expected direct ByteBuffer");
        }
        if (!ADDRESS_AVAILABLE) {
            throw new UnsupportedOperationException("Getting address is not supported");
        }
        return ByteBuffers.getAddressInternal(b);
    }

    private static long getAddressInternal(ByteBuffer b) {
        return UnsafeUtil.UNSAFE.getLong(b, NIO_BUFFER_ADDRESS_FIELD_OFFSET);
    }

    public static ByteBuffer makeAddressAlignedSlice(ByteBuffer directByteBuffer, int capacity, int alignment) {
        if (!directByteBuffer.isDirect()) {
            throw new IllegalArgumentException();
        }
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((alignment > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((capacity % alignment == 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)IntMath.isPowerOfTwo((int)alignment));
        long addr = ByteBuffers.getAddress(directByteBuffer);
        long alignedAddr = Maths.roundUp(addr, alignment);
        int offset = Math.toIntExact(alignedAddr - addr);
        directByteBuffer.position(offset);
        directByteBuffer.limit(offset + capacity);
        return ByteBuffers.slice(directByteBuffer);
    }

    public static void freeDirectByteBuffer(ByteBuffer buffer) {
        assert (buffer.isDirect());
        if (UnsafeUtil.UNSAFE_AVAILABLE) {
            UnsafeUtil.UNSAFE.invokeCleaner(buffer);
        }
    }

    static {
        if (UnsafeUtil.UNSAFE_AVAILABLE) {
            ByteBuffer directBuffer = ByteBuffers.allocateDirect(1, ByteOrder.nativeOrder());
            NIO_BUFFER_ADDRESS_FIELD_OFFSET = ByteBuffers.getFieldOffset(directBuffer, "address");
            ADDRESS_AVAILABLE = ByteBuffers.verifyAddressAccessibility(directBuffer);
        } else {
            ADDRESS_AVAILABLE = false;
            NIO_BUFFER_ADDRESS_FIELD_OFFSET = -1L;
        }
    }
}

