/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.net.ssl;

import com.google.common.base.Joiner;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;

public final class SSLContextFactory {
    private static final String PROTOCOL = "TLS";
    private static final String STORE_TYPE = "JKS";

    private SSLContextFactory() {
        throw new AssertionError();
    }

    public static SSLEngine clientEngine(SSLContext theContext) {
        SSLEngine aEngine = theContext.createSSLEngine();
        aEngine.setUseClientMode(true);
        return aEngine;
    }

    public static SSLEngine serverEngine(SSLContext theContext) {
        SSLEngine aEngine = theContext.createSSLEngine();
        aEngine.setUseClientMode(false);
        return aEngine;
    }

    public static SSLContext createSSLContext(String theKeyStorePath, char[] theKeyStorePasswd, String theTrustStorePath, char[] theTrustStorePasswd) throws SSLException {
        return SSLContextFactory.createSSLContext(STORE_TYPE, theKeyStorePath, theKeyStorePasswd, STORE_TYPE, theTrustStorePath, theTrustStorePasswd);
    }

    public static SSLContext createSSLContext(String theKeyStoreType, String theKeyStorePath, char[] theKeyStorePasswd, String theTrustStoreType, String theTrustStorePath, char[] theTrustStorePasswd) throws SSLException {
        try {
            SSLContext aContext = SSLContext.getInstance(PROTOCOL);
            KeyManagerFactory kmf = null;
            if (theKeyStorePath != null) {
                kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore aKeyStore = SSLContextFactory.loadKeyStore(theKeyStoreType, theKeyStorePath, theKeyStorePasswd);
                kmf.init(aKeyStore, theKeyStorePasswd);
            }
            TrustManagerFactory trustMgrFactory = null;
            if (theTrustStorePath != null) {
                KeyStore trustStore = SSLContextFactory.loadKeyStore(theTrustStoreType, theTrustStorePath, theTrustStorePasswd);
                trustMgrFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustMgrFactory.init(trustStore);
            }
            if (kmf == null && trustMgrFactory == null) {
                throw new SSLException("No information found to initialize either the key manager or trust manager, cannot create SSL context");
            }
            aContext.init(kmf == null ? null : kmf.getKeyManagers(), trustMgrFactory == null ? null : trustMgrFactory.getTrustManagers(), null);
            return aContext;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new SSLException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(String theKeyStoreType, String theKeyStorePath, char[] theKeyStorePasswd) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance(theKeyStoreType == null ? STORE_TYPE : theKeyStoreType);
        InputStream aInputStream = null;
        try {
            URL keystoreURL = null;
            if (theKeyStorePath == null) {
                for (File aFile : new File[]{new File(SSLContextFactory.path(System.getProperty("java.home"), "lib", "security", "jssecacerts")), new File(SSLContextFactory.path(System.getProperty("java.home"), "lib", "security", "cacerts"))}) {
                    if (!aFile.exists()) continue;
                    keystoreURL = aFile.toURI().toURL();
                    break;
                }
                if (keystoreURL == null) {
                    throw new KeyStoreException("Could not determine the path to the keystore");
                }
            } else if (!theKeyStorePath.equalsIgnoreCase("NONE")) {
                keystoreURL = SSLContextFactory.validateResourceURL(theKeyStorePath);
            }
            if (keystoreURL != null) {
                aInputStream = keystoreURL.openStream();
            }
            ks.load(aInputStream, (char[])(theKeyStorePasswd != null && theKeyStorePasswd.length == 0 ? null : theKeyStorePasswd));
        }
        catch (Throwable throwable) {
            Closeables.close(aInputStream, (boolean)true);
            throw throwable;
        }
        Closeables.close((Closeable)aInputStream, (boolean)true);
        return ks;
    }

    public static String path(String theSegment, String ... theSegments) {
        return Joiner.on((char)File.pathSeparatorChar).skipNulls().join(null, (Object)theSegment, (Object[])theSegments);
    }

    public static URL validateResourceURL(String thePath) throws KeyStoreException, MalformedURLException {
        if (thePath == null) {
            throw new IllegalArgumentException("null is not allowed for a keystore path");
        }
        try {
            return new URL(thePath);
        }
        catch (MalformedURLException e) {
            File aFile = new File(thePath);
            if (aFile.exists() && aFile.isFile()) {
                return aFile.toURI().toURL();
            }
            URL aURL = Thread.currentThread().getContextClassLoader().getResource(thePath);
            if (aURL != null) {
                return aURL;
            }
            throw new KeyStoreException("Unable to find a resource at " + thePath);
        }
    }
}

