/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.net;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.net.MediaType;

public final class RDFMediaTypes {
    public static final MediaType TURTLE = MediaType.create((String)"text", (String)"turtle");
    public static final MediaType TURTLE_DEPRECATED = MediaType.create((String)"application", (String)"x-turtle");
    public static final MediaType RDFXML = MediaType.create((String)"application", (String)"rdf+xml");
    public static final MediaType NTRIPLES = MediaType.create((String)"application", (String)"n-triples");
    public static final MediaType NTRIPLES_DEPRECATED = MediaType.create((String)"text", (String)"plain");
    public static final MediaType JSONLD = MediaType.create((String)"application", (String)"ld+json");
    public static final MediaType N3 = MediaType.create((String)"text", (String)"n3");
    public static final MediaType TRIG = MediaType.create((String)"application", (String)"trig");
    public static final MediaType TRIG_DEPRECATED = MediaType.create((String)"application", (String)"x-trig");
    public static final MediaType NQUADS = MediaType.create((String)"application", (String)"n-quads");
    public static final MediaType NQUADS_DEPRECATED = MediaType.create((String)"text", (String)"x-nquads");
    public static final MediaType CSV = MediaType.create((String)"text", (String)"csv");
    public static final MediaType TSV = MediaType.create((String)"text", (String)"tsv");
    public static final MediaType TSV2 = MediaType.create((String)"text", (String)"tab-separated-values");
    public static final MediaType SPARQL_XML = MediaType.create((String)"application", (String)"sparql-results+xml");
    public static final MediaType SPARQL_JSON = MediaType.create((String)"application", (String)"sparql-results+json");
    public static final MediaType SPARQL_BINARY = MediaType.create((String)"application", (String)"x-binary-rdf-results-table");
    public static final MediaType SPARQL_BOOLEAN = MediaType.create((String)"text", (String)"boolean");
    public static final MediaType SPARQL_UPDATE = MediaType.create((String)"application", (String)"sparql-update");
    public static final MediaType SPARQL_QUERY = MediaType.create((String)"application", (String)"sparql-query");
    public static final ImmutableList<MediaType> SPARQL_TYPES = ImmutableList.of((Object)SPARQL_XML, (Object)SPARQL_JSON, (Object)SPARQL_BINARY, (Object)SPARQL_BOOLEAN, (Object)CSV, (Object)TSV, (Object)TSV2);
    public static final ImmutableList<MediaType> RDF_TYPES = ImmutableList.of((Object)TURTLE, (Object)TURTLE_DEPRECATED, (Object)RDFXML, (Object)NTRIPLES, (Object)NTRIPLES_DEPRECATED, (Object)JSONLD, (Object)N3, (Object)TRIG, (Object)TRIG_DEPRECATED, (Object)NQUADS, (Object)NQUADS_DEPRECATED);
    public static final ImmutableList<MediaType> TURTLE_TYPES = ImmutableList.of((Object)TURTLE, (Object)TURTLE_DEPRECATED);
    public static final ImmutableList<MediaType> QUERY_RESULTS = ImmutableList.copyOf((Iterable)Iterables.concat(SPARQL_TYPES, RDF_TYPES));

    private RDFMediaTypes() {
        throw new AssertionError();
    }

    public static boolean isTurtle(MediaType theType) {
        return theType != null && theType.is(TURTLE) | theType.is(TURTLE_DEPRECATED);
    }

    public static boolean isQueryResults(MediaType theType) {
        return SPARQL_TYPES.contains((Object)theType);
    }

    public static boolean isRDF(MediaType theType) {
        for (MediaType aType : RDF_TYPES) {
            if (!aType.is(theType)) continue;
            return true;
        }
        return false;
    }
}

