/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.memory;

import com.complexible.common.memory.MemoryConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.lang.invoke.CallSite;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public enum PredefinedMemoryRatio {
    READ_OPTIMIZED(PredefinedMemoryRatio.mutableMap(MemoryConfiguration.HeapComponent.class, MemoryConfiguration.HeapComponent.DICT_VALUE_CACHE, 80, MemoryConfiguration.HeapComponent.DICT_INDEX_CACHE, 20), PredefinedMemoryRatio.mutableMap(MemoryConfiguration.NativeComponent.class, MemoryConfiguration.NativeComponent.QUERY_MEM_BLOCKS, 30, MemoryConfiguration.NativeComponent.STARROCKS_SIZE, 70), PredefinedMemoryRatio.mutableMap(MemoryConfiguration.StarrocksComponent.class, MemoryConfiguration.StarrocksComponent.MEMTABLE, 20, MemoryConfiguration.StarrocksComponent.BLOCK_CACHE, 30, MemoryConfiguration.StarrocksComponent.DICT_BLOCK_CACHE, 15, MemoryConfiguration.StarrocksComponent.TXN_BLOCK_CACHE, 10, MemoryConfiguration.StarrocksComponent.UNTRACKED_MEMORY, 25)),
    DEFAULT(PredefinedMemoryRatio.mutableMap(MemoryConfiguration.HeapComponent.class, MemoryConfiguration.HeapComponent.DICT_VALUE_CACHE, 50, MemoryConfiguration.HeapComponent.DICT_INDEX_CACHE, 50), PredefinedMemoryRatio.mutableMap(MemoryConfiguration.NativeComponent.class, MemoryConfiguration.NativeComponent.QUERY_MEM_BLOCKS, 30, MemoryConfiguration.NativeComponent.STARROCKS_SIZE, 70), PredefinedMemoryRatio.mutableMap(MemoryConfiguration.StarrocksComponent.class, MemoryConfiguration.StarrocksComponent.MEMTABLE, 40, MemoryConfiguration.StarrocksComponent.BLOCK_CACHE, 20, MemoryConfiguration.StarrocksComponent.DICT_BLOCK_CACHE, 10, MemoryConfiguration.StarrocksComponent.TXN_BLOCK_CACHE, 5, MemoryConfiguration.StarrocksComponent.UNTRACKED_MEMORY, 25)),
    WRITE_OPTIMIZED(PredefinedMemoryRatio.mutableMap(MemoryConfiguration.HeapComponent.class, MemoryConfiguration.HeapComponent.DICT_VALUE_CACHE, 20, MemoryConfiguration.HeapComponent.DICT_INDEX_CACHE, 80), PredefinedMemoryRatio.mutableMap(MemoryConfiguration.NativeComponent.class, MemoryConfiguration.NativeComponent.QUERY_MEM_BLOCKS, 20, MemoryConfiguration.NativeComponent.STARROCKS_SIZE, 80), PredefinedMemoryRatio.mutableMap(MemoryConfiguration.StarrocksComponent.class, MemoryConfiguration.StarrocksComponent.MEMTABLE, 40, MemoryConfiguration.StarrocksComponent.BLOCK_CACHE, 15, MemoryConfiguration.StarrocksComponent.DICT_BLOCK_CACHE, 10, MemoryConfiguration.StarrocksComponent.TXN_BLOCK_CACHE, 10, MemoryConfiguration.StarrocksComponent.UNTRACKED_MEMORY, 25)),
    BULK_LOAD(PredefinedMemoryRatio.mutableMap(MemoryConfiguration.HeapComponent.class, MemoryConfiguration.HeapComponent.DICT_VALUE_CACHE, 0, MemoryConfiguration.HeapComponent.DICT_INDEX_CACHE, 100), PredefinedMemoryRatio.mutableMap(MemoryConfiguration.NativeComponent.class, MemoryConfiguration.NativeComponent.QUERY_MEM_BLOCKS, 0, MemoryConfiguration.NativeComponent.STARROCKS_SIZE, 100), PredefinedMemoryRatio.mutableMap(MemoryConfiguration.StarrocksComponent.class, MemoryConfiguration.StarrocksComponent.MEMTABLE, 1, MemoryConfiguration.StarrocksComponent.BLOCK_CACHE, 0, MemoryConfiguration.StarrocksComponent.DICT_BLOCK_CACHE, 3, MemoryConfiguration.StarrocksComponent.TXN_BLOCK_CACHE, 0, MemoryConfiguration.StarrocksComponent.UNTRACKED_MEMORY, 96));

    private final Map<MemoryConfiguration.HeapComponent, Integer> heapComponents;
    private final Map<MemoryConfiguration.NativeComponent, Integer> nativeComponents;
    private final Map<MemoryConfiguration.StarrocksComponent, Integer> starrocksRatios;

    private PredefinedMemoryRatio(Map<MemoryConfiguration.HeapComponent, Integer> heapComponents, Map<MemoryConfiguration.NativeComponent, Integer> nativeComponents, Map<MemoryConfiguration.StarrocksComponent, Integer> starrocksComponents) {
        this.validateComponent(heapComponents, MemoryConfiguration.HeapComponent.values().length, "heap");
        this.validateComponent(nativeComponents, MemoryConfiguration.NativeComponent.values().length, "native");
        this.validateComponent(starrocksComponents, MemoryConfiguration.StarrocksComponent.values().length, "starrocks");
        this.heapComponents = heapComponents;
        this.nativeComponents = nativeComponents;
        this.starrocksRatios = starrocksComponents;
    }

    private <T extends Enum<T>> void validateComponent(Map<T, Integer> theComponents, int theValuesNum, String theMnemonic) {
        Preconditions.checkArgument((theComponents.size() == theValuesNum ? 1 : 0) != 0, (String)("Settings missing for some " + theMnemonic + " components: %s"), (Object)Sets.difference(theComponents.keySet(), (Set)Sets.newHashSet(theComponents.values())));
        this.validate(theComponents, theMnemonic);
    }

    public MemoryConfiguration withAvailableMemory(long nativeMem, long heapMem) {
        return new RatioMemoryConfiguration(this, nativeMem, heapMem);
    }

    public ImmutableMap<MemoryConfiguration.StarrocksComponent, Integer> getStarrocksRatios() {
        return ImmutableMap.copyOf(this.starrocksRatios);
    }

    public ImmutableMap<MemoryConfiguration.HeapComponent, Integer> getHeapRatios() {
        return ImmutableMap.copyOf(this.heapComponents);
    }

    public ImmutableMap<MemoryConfiguration.NativeComponent, Integer> getNativeRatios() {
        return ImmutableMap.copyOf(this.nativeComponents);
    }

    public void setRatios(Map<String, Object> theJsonMap) {
        for (Map.Entry<String, Object> aEntry : theJsonMap.entrySet()) {
            MemoryConfiguration.NativeComponent aNativeComponent;
            MemoryConfiguration.HeapComponent aHeapComponent;
            MemoryConfiguration.StarrocksComponent aRatioStatus = MemoryConfiguration.StarrocksComponent.getInstance(aEntry.getKey());
            if (aRatioStatus != null) {
                this.starrocksRatios.put(aRatioStatus, Float.valueOf(String.valueOf(aEntry.getValue())).intValue());
            }
            if ((aHeapComponent = MemoryConfiguration.HeapComponent.getInstance(aEntry.getKey())) != null) {
                this.heapComponents.put(aHeapComponent, Float.valueOf(String.valueOf(aEntry.getValue())).intValue());
            }
            if ((aNativeComponent = MemoryConfiguration.NativeComponent.getInstance(aEntry.getKey())) == null) continue;
            this.nativeComponents.put(aNativeComponent, Float.valueOf(String.valueOf(aEntry.getValue())).intValue());
        }
        this.validate(this.starrocksRatios, "Starrocks component");
        this.validate(this.heapComponents, "Heap component");
        this.validate(this.nativeComponents, "Native component");
    }

    private <T> void validate(Map<T, Integer> theComponentConfig, String theComponent) {
        double totalHeapMemory = theComponentConfig.values().stream().mapToDouble(Integer::intValue).sum();
        Preconditions.checkArgument((totalHeapMemory <= 100.0 ? 1 : 0) != 0, (String)("Invalid memory settings for " + theComponent + " components: %s"), theComponentConfig);
    }

    public String toString() {
        HashMap<CallSite, String> aResultMap = new HashMap<CallSite, String>();
        for (Map.Entry<MemoryConfiguration.HeapComponent, Integer> entry : this.heapComponents.entrySet()) {
            aResultMap.put((CallSite)((Object)("Heap." + entry.getKey().getOption())), String.valueOf(entry.getValue()));
        }
        for (Map.Entry<Enum, Integer> entry : this.nativeComponents.entrySet()) {
            aResultMap.put((CallSite)((Object)("Native." + ((MemoryConfiguration.NativeComponent)entry.getKey()).getOption())), String.valueOf(entry.getValue()));
        }
        for (Map.Entry<Enum, Integer> entry : this.starrocksRatios.entrySet()) {
            aResultMap.put((CallSite)((Object)("Starrocks." + ((MemoryConfiguration.StarrocksComponent)entry.getKey()).getOption())), String.valueOf(entry.getValue()));
        }
        return super.toString() + ((Object)aResultMap).toString();
    }

    private static <K extends Enum<K>> Map<K, Integer> mutableMap(Class<K> clazz, K k1, Integer v1, K k2, Integer v2) {
        EnumMap<K, Integer> map = new EnumMap<K, Integer>(clazz);
        map.put(k1, v1);
        map.put(k2, v2);
        return new HashMap(map);
    }

    private static <K extends Enum<K>> Map<K, Integer> mutableMap(Class<K> clazz, K k1, Integer v1, K k2, Integer v2, K k3, Integer v3, K k4, Integer v4, K k5, Integer v5) {
        EnumMap<K, Integer> map = new EnumMap<K, Integer>(clazz);
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return new HashMap(map);
    }

    private static class RatioMemoryConfiguration
    implements MemoryConfiguration {
        private final PredefinedMemoryRatio mode;
        private final long heapMem;
        private final long nativeMem;

        private RatioMemoryConfiguration(PredefinedMemoryRatio theMode, long theNativeMem, long theHeapMem) {
            this.mode = theMode;
            this.heapMem = theHeapMem;
            this.nativeMem = theNativeMem < 0L ? 0L : theNativeMem;
        }

        @Override
        public long getMemory(MemoryConfiguration.NativeComponent component) {
            return (long)this.mode.nativeComponents.get((Object)component).intValue() * this.nativeMem / 100L;
        }

        @Override
        public long getMemory(MemoryConfiguration.HeapComponent component) {
            return (long)this.mode.heapComponents.get((Object)component).intValue() * this.heapMem / 100L;
        }
    }
}

