/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.memory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlatformDependent {
    private static final Logger logger = LoggerFactory.getLogger(PlatformDependent.class);
    private static final Pattern MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN = Pattern.compile("\\s*-XX:MaxDirectMemorySize\\s*=\\s*([0-9]+)\\s*([kKmMgG]?)\\s*$");
    private static final IVM VM = DefaultVM.Instance;
    private static final long MAX_DIRECT_MEMORY = PlatformDependent.maxDirectMemory0();

    public static long maxDirectMemory() {
        return MAX_DIRECT_MEMORY;
    }

    private static long maxDirectMemory0() {
        long maxDirectMemory = 0L;
        try {
            if (VM.isAvailable()) {
                maxDirectMemory = VM.maxDirectMemory();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (maxDirectMemory > 0L) {
            return maxDirectMemory;
        }
        try {
            Class<?> mgmtFactoryClass = Class.forName("java.lang.management.ManagementFactory", true, ClassLoader.getSystemClassLoader());
            Class<?> runtimeClass = Class.forName("java.lang.management.RuntimeMXBean", true, ClassLoader.getSystemClassLoader());
            Object runtime = mgmtFactoryClass.getDeclaredMethod("getRuntimeMXBean", new Class[0]).invoke(null, new Object[0]);
            List vmArgs = (List)runtimeClass.getDeclaredMethod("getInputArguments", new Class[0]).invoke(runtime, new Object[0]);
            for (int i = vmArgs.size() - 1; i >= 0; --i) {
                Matcher m = MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN.matcher((CharSequence)vmArgs.get(i));
                if (!m.matches()) continue;
                maxDirectMemory = Long.parseLong(m.group(1));
                switch (m.group(2).charAt(0)) {
                    case 'K': 
                    case 'k': {
                        maxDirectMemory *= 1024L;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        maxDirectMemory *= 0x100000L;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        maxDirectMemory *= 0x40000000L;
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (maxDirectMemory <= 0L) {
            maxDirectMemory = Runtime.getRuntime().maxMemory();
            logger.debug("maxDirectMemory: {} bytes (maybe)", (Object)maxDirectMemory);
        } else {
            logger.debug("maxDirectMemory: {} bytes", (Object)maxDirectMemory);
        }
        return maxDirectMemory;
    }

    private PlatformDependent() {
        throw new AssertionError();
    }

    static interface IVM
    extends JVMInternal {
        public long maxDirectMemory();
    }

    private static enum DefaultVM implements IVM
    {
        Instance;

        private final long mMaxDirectMemory;
        private final boolean mAvailable;

        private DefaultVM() {
            boolean aAvailable = false;
            long aDirect = 0L;
            try {
                Method m = this.getMethod();
                aDirect = ((Number)m.invoke(null, new Object[0])).longValue();
                aAvailable = true;
            }
            catch (ClassNotFoundException e) {
                logger.debug("misc.VM is not available", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.debug("misc.VM is missing an expected method and will not be available", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.debug("misc.VM", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.debug("There was an error during an misc.VM operation", e.getTargetException());
            }
            this.mMaxDirectMemory = aDirect;
            this.mAvailable = aAvailable;
        }

        private Method getMethod() throws ClassNotFoundException, NoSuchMethodException {
            try {
                return this.loadMethod("jdk.internal.misc.VM");
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                return this.loadMethod("sun.misc.VM");
            }
        }

        private Method loadMethod(String thisClassName) throws ClassNotFoundException, NoSuchMethodException {
            Class<?> vmClass = Class.forName(thisClassName, true, ClassLoader.getSystemClassLoader());
            return vmClass.getDeclaredMethod("maxDirectMemory", new Class[0]);
        }

        @Override
        public long maxDirectMemory() {
            return this.mMaxDirectMemory;
        }

        @Override
        public boolean isAvailable() {
            return this.mAvailable;
        }
    }

    static interface JVMInternal {
        public boolean isAvailable();
    }
}

