/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.memory;

import com.complexible.common.memory.PlatformDependent;
import com.google.common.collect.Iterables;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;

public final class MemoryInfo {
    private static final OperatingSystemMXBean OS = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private static final MemoryMXBean MEMORY_BEAN = ManagementFactory.getMemoryMXBean();
    private static final BufferPoolMXBean DIRECT_MEM = (BufferPoolMXBean)Iterables.find(ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class), pool -> pool.getName().equals("direct"));
    private static final BufferPoolMXBean MAPPED_MEM = (BufferPoolMXBean)Iterables.find(ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class), pool -> pool.getName().equals("mapped"));

    public static long getHeapMemInit() {
        return MEMORY_BEAN.getHeapMemoryUsage().getInit();
    }

    public static long getHeapMemAllocated() {
        return MEMORY_BEAN.getHeapMemoryUsage().getCommitted();
    }

    public static long getHeapMemUsed() {
        return MEMORY_BEAN.getHeapMemoryUsage().getUsed();
    }

    public static long getHeapMemMax() {
        return MEMORY_BEAN.getHeapMemoryUsage().getMax();
    }

    public static long getDirectMemUsed() {
        return DIRECT_MEM.getMemoryUsed();
    }

    public static long getDirectMemMax() {
        return PlatformDependent.maxDirectMemory();
    }

    public static long getMappedMemUsed() {
        return MAPPED_MEM.getMemoryUsed();
    }

    public static long getSystemMax() {
        return OS.getTotalPhysicalMemorySize();
    }
}

