/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.impl;

import com.complexible.common.io.IOFile;
import com.complexible.common.io.disk.DiskDirectory;
import com.complexible.common.io.disk.DiskFile;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Longs;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SerialFileCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerialFileCreator.class);
    private final DiskDirectory mDirectory;
    private final String mFilename;
    private final AtomicLong mCurrentID;
    private final IOFile.Mode mFileMode;
    private static final Comparator<IOFile> NUMBERED_EXTENSION_COMP = new Comparator<IOFile>(){

        @Override
        public int compare(IOFile f1, IOFile f2) {
            return Longs.compare((long)SerialFileCreator.getID(f1), (long)SerialFileCreator.getID(f2));
        }
    };
    private static final Comparator<String> NUMBERED_EXTENSION_COMP_STRING = new Comparator<String>(){

        @Override
        public int compare(String f1, String f2) {
            return Longs.compare((long)SerialFileCreator.toID(f1), (long)SerialFileCreator.toID(f2));
        }
    };

    public SerialFileCreator(DiskDirectory theDirectory, String theFilename, DirectoryMode theMode, IOFile.Mode theFileMode) throws IOException {
        this.mDirectory = theDirectory;
        this.mFilename = theFilename;
        this.mFileMode = theFileMode;
        this.mCurrentID = new AtomicLong(this.readDirectory(theMode));
    }

    public DiskDirectory getDirectory() {
        return this.mDirectory;
    }

    @VisibleForTesting
    public IOFile current() throws IOException {
        if (this.mCurrentID.compareAndSet(-1L, 0L)) {
            String name = this.toFilename(0L);
            this.mDirectory.deleteFileIfExists(name);
        }
        return this.get(this.mCurrentID.get());
    }

    public void delete(long theID) throws IOException {
        this.mDirectory.deleteFile(this.toFilename(theID));
    }

    public DiskFile get(long theID) throws IOException {
        return this.mDirectory.getFile(this.toFilename(theID), this.mFileMode);
    }

    public DiskFile next() throws IOException {
        long nextID = this.mCurrentID.incrementAndGet();
        String next = this.toFilename(nextID);
        this.mDirectory.deleteFileIfExists(next);
        return this.get(nextID);
    }

    public DiskFile[] getFiles() throws IOException {
        List<String> filenames = this.filenames();
        DiskFile[] files = new DiskFile[filenames.size()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = this.mDirectory.getFile(filenames.get(i), this.mFileMode);
        }
        Arrays.sort(files, NUMBERED_EXTENSION_COMP);
        return files;
    }

    public void reload(DirectoryMode theMode) throws IOException {
        this.mCurrentID.set(this.readDirectory(theMode));
    }

    private List<String> filenames() throws IOException {
        NumberedExtension predicate = new NumberedExtension(this.mFilename);
        return this.mDirectory.getFileNames().stream().filter(predicate).sorted(NUMBERED_EXTENSION_COMP_STRING).collect(Collectors.toList());
    }

    private String toFilename(long theID) {
        return this.mFilename + "." + theID;
    }

    private static long toID(String theFilename) {
        return Long.parseLong(theFilename.substring(theFilename.lastIndexOf(46) + 1));
    }

    private long readDirectory(DirectoryMode theMode) throws IOException {
        List<String> files = this.filenames();
        LOGGER.debug("Found " + files.size() + " valid serial files in " + String.valueOf(this.mDirectory));
        if (files.size() == 0) {
            return -1L;
        }
        switch (theMode.ordinal()) {
            case 0: {
                this.delete(files);
                break;
            }
            case 1: {
                this.delete(files.subList(0, files.size() - 1));
                return SerialFileCreator.toID(files.get(files.size() - 1));
            }
            case 2: {
                int i;
                for (i = 0; i < files.size() && SerialFileCreator.toID(files.get(i)) == (long)i; ++i) {
                }
                this.delete(files.subList(i, files.size()));
                if (i <= 0) break;
                return i - 1;
            }
            case 3: {
                return SerialFileCreator.toID(files.get(files.size() - 1));
            }
        }
        return -1L;
    }

    private void delete(Collection<String> theFiles) throws IOException {
        LOGGER.debug("Deleting " + theFiles.size() + " serial files from " + String.valueOf(this.mDirectory));
        for (String file : theFiles) {
            this.mDirectory.deleteFile(file);
        }
    }

    public static long getID(IOFile f) {
        return SerialFileCreator.toID(f.getName());
    }

    public String toString() {
        return String.valueOf(this.mDirectory) + File.separator + this.mFilename + ".N";
    }

    public static enum DirectoryMode {
        CLEAR,
        KEEP_LAST,
        KEEP_FIRSTS_ORDERED,
        KEEP_ALL;

    }

    private static class NumberedExtension
    implements Predicate<String> {
        private final Pattern pattern;

        public NumberedExtension(String filename) {
            this.pattern = Pattern.compile(filename + ".\\d+");
        }

        @Override
        public boolean test(String theFilename) {
            return this.pattern.matcher(theFilename).matches();
        }
    }
}

