/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.impl;

import com.complexible.common.io.ObjectWriter;
import com.complexible.common.io.ObjectWriterFactory;
import com.complexible.common.io.Page;
import com.complexible.common.io.PageByteWriter;
import com.complexible.common.io.PageListener;
import com.complexible.common.io.PageManager;
import com.complexible.common.io.PageObjectWriter;
import com.complexible.common.io.impl.AbstractObjectWriter;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.IOException;

public class PageObjectWriterImpl<T>
extends AbstractObjectWriter<T>
implements PageObjectWriter<T> {
    private static final boolean DEBUG = false;
    private final PageManager mPageSupplier;
    private final ObjectWriterFactory<T> mFactory;
    private PageListener<T> mListener;
    private Page mCurrentPage;
    private T mPageStart;
    private T mPageEnd;
    private int mObjectCount;
    private int mPageLimit = -1;
    private ObjectWriter<T> mObjectWriter;
    private PageByteWriter mByteWriter;
    private final StringBuilder mDebug = null;

    public PageObjectWriterImpl(PageManager thePageSupplier, ObjectWriterFactory<T> theFactory) {
        Preconditions.checkNotNull((Object)thePageSupplier);
        Preconditions.checkNotNull(theFactory);
        this.mPageSupplier = thePageSupplier;
        this.mFactory = theFactory;
    }

    @Override
    public void limit(int thePageLimit) {
        this.mPageLimit = thePageLimit;
        if (this.mObjectWriter != null) {
            this.mByteWriter.limit(this.mPageLimit);
        }
    }

    @Override
    public void write(T theObject) throws IOException {
        if (this.mObjectCount == 0) {
            this.createPage();
            this.mPageStart = theObject;
        }
        long aPagePos = this.mByteWriter.getPosition();
        this.mObjectWriter.write(theObject);
        if (this.mByteWriter.isOverflowed()) {
            this.mByteWriter.setPosition(aPagePos);
            this.flushPage();
            this.createPage();
            this.mObjectWriter.write(theObject);
            this.mPageStart = theObject;
            assert (!this.mByteWriter.isOverflowed()) : "Cannot fit a single object in a page";
        }
        this.mPageEnd = theObject;
        ++this.mObjectCount;
    }

    @Override
    public void cancel() {
        if (this.mObjectCount > 0) {
            this.mPageSupplier.freePage(this.mCurrentPage.getID());
            this.reset();
        }
    }

    @Override
    public void flush() throws IOException {
        this.flushPage();
    }

    @Override
    public void listener(PageListener<T> theListener) {
        this.mListener = theListener;
    }

    private void flushPage() throws IOException {
        if (this.mObjectCount > 0) {
            this.mObjectWriter.flush();
            if (this.mListener != null) {
                this.mListener.pageCreated(this.mCurrentPage.getID(), this.mPageStart, this.mPageEnd, this.mObjectCount, this.bytesWritten());
            }
            this.reset();
        }
    }

    private void reset() {
        this.mCurrentPage = null;
        this.mPageEnd = null;
        this.mPageStart = null;
        this.mObjectCount = 0;
        this.mPageLimit = -1;
        this.mByteWriter = null;
        this.mObjectWriter = null;
    }

    private void createPage() throws IOException {
        this.mCurrentPage = this.mPageSupplier.newPage();
        this.mByteWriter = this.mCurrentPage.write();
        this.mObjectWriter = this.mFactory.writer(this.mByteWriter);
        if (this.mPageLimit != -1) {
            this.mByteWriter.limit(this.mPageLimit);
        }
    }

    @Override
    public int objectsWritten() {
        return this.mObjectCount;
    }

    @Override
    public int bytesWritten() {
        try {
            return this.mByteWriter == null ? 0 : Ints.saturatedCast((long)this.mByteWriter.getPosition());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

