/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.impl;

import com.complexible.common.io.Page;
import com.complexible.common.io.PageManager;
import com.complexible.common.io.PagedFileFactory;
import com.complexible.common.io.disk.DiskDirectory;
import com.complexible.common.io.impl.MultiPage;
import com.complexible.common.io.impl.PageManagerImpl;
import com.complexible.common.io.impl.PagedFileImpl;
import com.complexible.common.io.impl.SinglePage;
import com.google.common.base.Preconditions;
import java.io.IOException;

public final class PageManagerBuilder {
    private static final int NO_SIZE = -1;
    private int mPageSize = -1;
    private long mFileSize = -1L;
    private boolean mClear = false;
    private String mFileName = null;
    private boolean mMultiPage = false;
    private boolean isReadOnly = false;
    private boolean isTemp = false;

    public PageManagerBuilder fileName(String theFileName) {
        this.mFileName = theFileName;
        return this;
    }

    public PageManagerBuilder clear() {
        this.mClear = true;
        return this;
    }

    public PageManagerBuilder fileSize(long theSize) {
        this.mFileSize = theSize;
        return this;
    }

    public PageManagerBuilder pageSize(int theSize) {
        this.mPageSize = theSize;
        return this;
    }

    public PageManagerBuilder multiPage() {
        this.mMultiPage = true;
        return this;
    }

    public PageManagerBuilder singlePage() {
        this.mMultiPage = false;
        return this;
    }

    public PageManagerBuilder readOnly() {
        this.isReadOnly = true;
        return this;
    }

    public PageManagerBuilder temporary() {
        this.isTemp = true;
        return this;
    }

    public PageManager build(DiskDirectory theDirectory) throws IOException {
        Preconditions.checkArgument((this.mFileSize != -1L ? 1 : 0) != 0, (Object)"You must set a file size for the page manager.");
        Preconditions.checkArgument((this.mPageSize != -1 ? 1 : 0) != 0, (Object)"You must set a page size for the page manager.");
        Preconditions.checkArgument((this.mFileName != null ? 1 : 0) != 0, (Object)"You must specify a file name for the page manager");
        return new PageManagerImpl(theDirectory, this.mFileName, this.createPagedFileFactory(), this.createPageFactory(), this.mFileSize, this.mPageSize, this.mClear, this.isTemp, this.isReadOnly);
    }

    private Page.Factory createPageFactory() {
        if (this.mMultiPage) {
            return new MultiPage.Factory();
        }
        return new SinglePage.Factory();
    }

    private PagedFileFactory createPagedFileFactory() {
        return PagedFileImpl::new;
    }
}

