/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.impl;

import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.complexible.common.io.ByteReader;
import com.complexible.common.io.IOFile;
import com.complexible.common.io.Page;
import com.complexible.common.io.PageByteWriter;
import com.complexible.common.io.PageManager;
import com.complexible.common.io.PagedFile;
import com.complexible.common.io.impl.AbstractByteReader;
import com.complexible.common.io.impl.AbstractByteWriter;
import com.complexible.common.io.impl.AbstractPage;
import com.complexible.common.io.mem.MemoryByteReader;
import com.complexible.common.io.mem.MemoryByteWriter;
import java.io.EOFException;
import java.io.IOException;

final class MultiPage
extends AbstractPage {
    private static final int HEADER_SIZE = 16;
    private static final int NOT_LINKED = 1470419052;
    private static final int LINKED = 1470419053;
    private static final int AFTER_MAGIC = 4;
    private static final int AFTER_PAGEID = 12;
    private static final int MAX = 0x100000;

    public MultiPage(PagedFile theFile, long theFilePosition, long theID) {
        super(theFile, theFilePosition, theID);
    }

    @Override
    public int getMaxSize() {
        return this.mPagedFile.getPageSize() - 16;
    }

    @Override
    public ByteReader read() throws IOException {
        int aTotalSize = MultiPage.traversePageLinks(this, null);
        if (aTotalSize <= 0x100000) {
            byte[] aBuffer = new byte[aTotalSize];
            MultiPage.traversePageLinks(this, aBuffer);
            return new MemoryByteReader(aBuffer);
        }
        return new MultiPageByteReader(this, aTotalSize);
    }

    private static int traversePageLinks(AbstractPage thePage, byte[] theArray) throws IOException {
        int aTotalSize = 0;
        int magicNumber = 1470419053;
        while (magicNumber == 1470419053) {
            IOFile aFile = thePage.getPagedFile().getFile();
            long aPos = thePage.mFilePosition;
            if (aFile.length() < aPos + 4L) break;
            magicNumber = aFile.readInt(aPos);
            aPos += 4L;
            if (magicNumber == 1470419053) {
                long aNextPageID = aFile.readLong(aPos);
                thePage = (AbstractPage)thePage.getManager().getPage(aNextPageID);
                aPos += 8L;
            } else if (magicNumber != 1470419052) break;
            int aPageSize = aFile.readInt(aPos);
            if (theArray != null) {
                aFile.read(theArray, aTotalSize, aPageSize, aPos + 4L);
            }
            aTotalSize += aPageSize;
        }
        return aTotalSize;
    }

    @Override
    public PageByteWriter write() throws IOException {
        return new MultiPageWriter(this);
    }

    @Override
    public PageByteWriter append() throws IOException {
        return new MultiPageWriter(this, true);
    }

    private void freeLinkedPages() throws IOException {
        LongArrayList aLinkedPages = new LongArrayList();
        MultiPage thisPage = this;
        PageManager aManager = this.getManager();
        while (thisPage != null) {
            long aFilePosition;
            IOFile aFile = thisPage.getPagedFile().getFile();
            int magicNumber = aFile.readInt(aFilePosition = thisPage.mFilePosition);
            if (magicNumber == 1470419053) {
                long id = aFile.readLong(aFilePosition + 4L);
                aLinkedPages.add(id);
                thisPage = (MultiPage)aManager.getPage(id);
                continue;
            }
            thisPage = null;
        }
        for (LongCursor aCursor : aLinkedPages) {
            aManager.freePage(aCursor.value);
        }
    }

    private void freeLinkedPages2() throws IOException {
        LongArrayList aLinkedPages = new LongArrayList();
        MultiPage thisPage = this;
        PageManager aManager = this.getManager();
        while (thisPage != null) {
            IOFile aFile = thisPage.getPagedFile().getFile();
            long aFilePosition = thisPage.mFilePosition;
            if (aFile.length() >= aFilePosition + 4L && aFile.readInt(aFilePosition) == 1470419053) {
                thisPage.getPagedFile().getFile().writeInt(1470419052, thisPage.mFilePosition);
                long id = aFile.readLong(aFilePosition + 4L);
                aLinkedPages.add(id);
                thisPage = (MultiPage)aManager.getPage(id);
                continue;
            }
            thisPage = null;
        }
        for (LongCursor aCursor : aLinkedPages) {
            aManager.freePage(aCursor.value);
        }
    }

    private boolean writeData(byte[] theData, long thePosition, int offset, int length) throws IOException {
        if (length > this.getMaxSize()) {
            throw new IOException("Data is too big for page. " + length + " > " + this.getMaxSize());
        }
        this.mPagedFile.getFile().writeInt(length, thePosition);
        this.mPagedFile.getFile().write(theData, thePosition + 4L, offset, length);
        return true;
    }

    private boolean writeData(byte[] theData, long thePosition, int offset, int length, long theOffset, int theSize) throws IOException {
        if (length > this.getMaxSize()) {
            throw new IOException("Data is too big for page. " + length + " > " + this.getMaxSize());
        }
        this.mPagedFile.getFile().writeInt(theSize, thePosition);
        this.mPagedFile.getFile().write(theData, thePosition + 4L + theOffset, offset, length);
        return true;
    }

    private static final class MultiPageByteReader
    extends AbstractByteReader {
        private final long mLength;
        private long mGlobalPosition;
        private long mPagePosition;
        private long mPageLength;
        private AbstractPage mCurrPage;
        private byte[] mBuffer;
        private long mNextPageID = -1L;

        private MultiPageByteReader(AbstractPage theFirstPage, long theLength) throws IOException {
            this.mLength = theLength;
            this.mBuffer = new byte[theFirstPage.getMaxSize()];
            this.loadPage(theFirstPage);
        }

        private void next() throws IOException {
            this.mCurrPage = (AbstractPage)this.mCurrPage.getManager().getPage(this.mNextPageID);
            this.mNextPageID = -1L;
            this.loadPage(this.mCurrPage);
        }

        private void loadPage(AbstractPage theFirstPage) throws IOException {
            long aFilePosition = theFirstPage.mFilePosition;
            int magicNumber = theFirstPage.getPagedFile().getFile().readInt(aFilePosition);
            aFilePosition += 4L;
            if (magicNumber == 1470419053) {
                this.mNextPageID = theFirstPage.getPagedFile().getFile().readLong(aFilePosition);
                aFilePosition += 8L;
            } else if (magicNumber != 1470419052) {
                this.mGlobalPosition = this.mLength;
            }
            this.mCurrPage = theFirstPage;
            this.mPageLength = theFirstPage.getPagedFile().getFile().readInt(aFilePosition);
            this.mPagePosition = 0L;
            theFirstPage.getPagedFile().getFile().read(this.mBuffer, aFilePosition += 4L);
        }

        @Override
        public long length() throws IOException {
            return this.mLength;
        }

        @Override
        public long getPosition() throws IOException {
            return this.mGlobalPosition;
        }

        @Override
        public void setPosition(long thePosition) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte readByte() throws IOException {
            if (this.mPagePosition == this.mPageLength) {
                if (this.mNextPageID != -1L) {
                    this.next();
                } else {
                    throw new EOFException();
                }
            }
            ++this.mGlobalPosition;
            return this.mBuffer[(int)this.mPagePosition++];
        }
    }

    private static class MultiPageWriter
    extends AbstractByteWriter
    implements PageByteWriter {
        private MultiPage mPage;
        private long mLength;
        private long mPosition = 0L;
        private final byte[] mBuffer;
        private int mBufferPosition;
        private int mPageSpace;

        public MultiPageWriter(MultiPage thePage) throws IOException {
            this(thePage, false);
        }

        public MultiPageWriter(MultiPage thePage, boolean theAppend) throws IOException {
            this.mPage = thePage;
            this.mLength = 0L;
            this.mBuffer = new byte[thePage.getMaxSize()];
            this.mBufferPosition = 0;
            this.mPageSpace = thePage.getMaxSize();
            if (!theAppend) {
                thePage.freeLinkedPages2();
                thePage.getPagedFile().getFile().writeInt(1470419052, thePage.mFilePosition);
            } else {
                int aTotalSize = 0;
                int magicNumber = 1470419053;
                MultiPage aPage = thePage;
                while (magicNumber == 1470419053) {
                    IOFile aFile = aPage.getPagedFile().getFile();
                    long aPos = aPage.mFilePosition;
                    magicNumber = aFile.readInt(aPos);
                    aPos += 4L;
                    if (magicNumber == 1470419053) {
                        long aNextPageID = aFile.readLong(aPos);
                        aPage = (MultiPage)aPage.getManager().getPage(aNextPageID);
                        aPos += 8L;
                    } else if (magicNumber != 1470419052) break;
                    int aPageSize = aFile.readInt(aPos);
                    aTotalSize += aPageSize;
                    this.mPageSpace = aPage.getMaxSize() - aPageSize;
                }
                this.mPosition = aTotalSize;
                this.mLength = aTotalSize;
                this.mPage = aPage;
            }
        }

        @Override
        public void limit(int thePageLimit) {
        }

        @Override
        public long length() throws IOException {
            return this.mLength;
        }

        @Override
        public long getPosition() throws IOException {
            return this.mPosition;
        }

        private void loadPageIntoBuffer() throws IOException {
            int aLen = this.mPage.getPagedFile().getFile().readInt(this.mPage.mFilePosition + 4L);
            this.mPage.getPagedFile().getFile().read(this.mBuffer, this.mPage.mFilePosition + 4L + 4L);
            this.mBufferPosition = aLen;
            this.mPageSpace = this.mPage.getMaxSize() - aLen;
        }

        @Override
        public void setPosition(long thePosition) throws IOException {
            int nBytesToWrite;
            long aBytesToSkip;
            this.flush();
            if (aBytesToSkip < 0L) {
                int aAbs;
                int aPageSize = this.mPage.getMaxSize() - this.mPageSpace;
                if (aPageSize > (aAbs = Math.abs((int)aBytesToSkip))) {
                    int aNewPos = aPageSize - aAbs;
                    this.loadPageIntoBuffer();
                    this.mPosition = thePosition;
                    this.mBufferPosition = aNewPos;
                    return;
                }
                throw new IllegalArgumentException("Cannot jump back to an earlier page");
            }
            if (aBytesToSkip < (long)this.mPageSpace) {
                this.loadPageIntoBuffer();
                this.mPosition = thePosition;
                this.mPageSpace = (int)((long)this.mPageSpace - aBytesToSkip);
                this.mBufferPosition = (int)((long)this.mBufferPosition + aBytesToSkip);
                return;
            }
            boolean newPage = false;
            MultiPage thisPage = this.mPage;
            for (aBytesToSkip = thePosition - this.mPosition; aBytesToSkip >= (long)this.mPageSpace; aBytesToSkip -= (long)nBytesToWrite) {
                MultiPage nextPage;
                PagedFile aPagedFile = thisPage.getPagedFile();
                long aFilePosition = thisPage.mFilePosition;
                IOFile aFile = aPagedFile.getFile();
                if (!newPage && aFile.length() >= aFilePosition + 4L && aFile.readInt(aFilePosition) == 1470419053) {
                    long id = aFile.readLong(aFilePosition + 4L);
                    nextPage = (MultiPage)thisPage.getManager().getPage(id);
                } else {
                    nextPage = (MultiPage)thisPage.getManager().newPage();
                    newPage = true;
                }
                aFile.writeInt(1470419053, aFilePosition);
                aFile.writeLong(nextPage.getID(), aFilePosition + 4L);
                nBytesToWrite = thisPage.getMaxSize();
                aFile.writeInt(nBytesToWrite, aFilePosition + 12L);
                thisPage = nextPage;
                this.mPageSpace = nextPage.getMaxSize();
            }
            if (aBytesToSkip > 0L) {
                this.mPageSpace = (int)((long)this.mPageSpace - aBytesToSkip);
            }
            this.mPosition = thePosition;
            this.mBufferPosition = 0;
            this.mPage = thisPage;
        }

        @Override
        public void writeByte(byte theValue) throws IOException {
            if (this.mPosition == this.mLength) {
                ++this.mLength;
            }
            ++this.mPosition;
            if (this.mBufferPosition == this.mBuffer.length) {
                this.flush();
            }
            this.mBuffer[this.mBufferPosition++] = theValue;
        }

        @Override
        public void flush() throws IOException {
            int nBytesWanted;
            int nBytesToWrite;
            boolean newPage = false;
            MultiPage thisPage = this.mPage;
            int offset = 0;
            for (nBytesWanted = this.mBufferPosition; nBytesWanted >= this.mPageSpace; nBytesWanted -= nBytesToWrite) {
                MultiPage nextPage;
                PagedFile aPagedFile = thisPage.getPagedFile();
                long aFilePosition = thisPage.mFilePosition;
                IOFile aFile = aPagedFile.getFile();
                if (!newPage && aFile.length() >= aFilePosition + 4L && aFile.readInt(aFilePosition) == 1470419053) {
                    long id = aFile.readLong(aFilePosition + 4L);
                    nextPage = (MultiPage)thisPage.getManager().getPage(id);
                } else {
                    nextPage = (MultiPage)thisPage.getManager().newPage();
                    newPage = true;
                }
                aFile.writeInt(1470419053, aFilePosition);
                aFile.writeLong(nextPage.getID(), aFilePosition + 4L);
                nBytesToWrite = thisPage.getMaxSize();
                thisPage.writeData(this.mBuffer, aFilePosition + 12L, offset, nBytesToWrite);
                thisPage = nextPage;
                offset += nBytesToWrite;
                this.mPageSpace = nextPage.getMaxSize();
            }
            if (nBytesWanted > 0 || this.mBufferPosition == 0) {
                long aFilePosition = thisPage.mFilePosition;
                thisPage.getPagedFile().getFile().writeInt(1470419052, aFilePosition);
                int aPageSize = thisPage.getMaxSize() - this.mPageSpace;
                thisPage.writeData(this.mBuffer, aFilePosition + 4L, offset, nBytesWanted, aPageSize, aPageSize + nBytesWanted);
                this.mPageSpace -= nBytesWanted;
            }
            this.mBufferPosition = 0;
            this.mPage = thisPage;
        }

        @Override
        public void write(byte[] theData, int theOffset, int theLength) throws IOException {
            if (theLength < this.mBuffer.length - this.mBufferPosition) {
                System.arraycopy(theData, theOffset, this.mBuffer, this.mBufferPosition, theLength);
                this.mBufferPosition += theLength;
                if (this.mPosition == this.mLength) {
                    this.mLength += (long)theLength;
                }
                this.mPosition += (long)theLength;
            } else {
                for (int i = theOffset; i < theOffset + theLength && i < theData.length; ++i) {
                    this.writeByte(theData[i]);
                }
            }
        }
    }

    public static class Factory
    implements Page.Factory {
        @Override
        public MultiPage create(PagedFile theFile, long theFilePosition, long theID) {
            return new MultiPage(theFile, theFilePosition, theID);
        }

        @Override
        public int getReservedPageSize() {
            return 16;
        }
    }

    private static class Writer
    extends MemoryByteWriter
    implements PageByteWriter {
        private MultiPage mPage;

        public Writer(MultiPage mPage) {
            this.mPage = mPage;
        }

        @Override
        public void limit(int thePageLimit) {
        }

        @Override
        public void flush() throws IOException {
            int nBytesWanted;
            int nBytesToWrite;
            byte[] theData = this.bytes;
            int offset = 0;
            int length = this.position;
            boolean newPage = false;
            MultiPage thisPage = this.mPage;
            for (nBytesWanted = Math.min(length, theData.length - offset); nBytesWanted > thisPage.getMaxSize(); nBytesWanted -= nBytesToWrite) {
                MultiPage nextPage;
                PagedFile aPagedFile = thisPage.getPagedFile();
                long aFilePosition = thisPage.mFilePosition;
                int magicNumber = aPagedFile.getFile().readInt(aFilePosition);
                if (!newPage && magicNumber == 1470419053) {
                    long id = aPagedFile.getFile().readLong(aFilePosition + 4L);
                    nextPage = (MultiPage)thisPage.getManager().getPage(id);
                } else {
                    nextPage = (MultiPage)thisPage.getManager().newPage();
                    newPage = true;
                }
                aPagedFile.getFile().writeInt(1470419053, aFilePosition);
                aPagedFile.getFile().writeLong(nextPage.getID(), aFilePosition + 4L);
                nBytesToWrite = thisPage.getMaxSize();
                thisPage.writeData(theData, aFilePosition + 12L, offset, nBytesToWrite);
                thisPage = nextPage;
                offset += nBytesToWrite;
            }
            if (!newPage) {
                thisPage.freeLinkedPages();
            }
            if (nBytesWanted > 0 || length == 0) {
                long aFilePosition = thisPage.mFilePosition;
                thisPage.getPagedFile().getFile().writeInt(1470419052, aFilePosition);
                thisPage.writeData(theData, aFilePosition + 4L, offset, nBytesWanted);
            }
        }
    }
}

