/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.impl;

import com.complexible.common.io.IOFile;
import com.complexible.common.io.Page;
import com.complexible.common.io.PageManager;
import com.complexible.common.io.PagedFile;
import com.complexible.common.io.disk.DiskFile;
import com.complexible.common.io.impl.PageNotFoundException;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractPagedFile
implements PagedFile {
    protected static final int MAGIC_NUMBER = 91901190;
    public static final int HEADER_SIZE = 8;
    protected static final int MAGIC_NUMBER_POS = 0;
    protected static final int N_PAGES_POS = 4;
    protected final PageManager mManager;
    protected final int mID;
    protected final DiskFile mFile;
    private final AtomicInteger mNumberOfPages = new AtomicInteger(0);

    public AbstractPagedFile(PageManager theManager, int theID, DiskFile theFile) throws IOException {
        this.mManager = theManager;
        this.mID = theID;
        this.mFile = theFile;
        this.processHeader();
    }

    private void processHeader() throws IOException {
        IOFile aFile = this.getFile();
        if (aFile.length() >= 4L && aFile.readInt(0L) == 91901190) {
            int aNumberOfPages = this.mFile.readInt(4L);
            assert (aNumberOfPages >= 0);
            assert (aNumberOfPages <= this.mManager.getMaxNumberPagesPerFile()) : "Page count " + aNumberOfPages + " > " + this.mManager.getMaxNumberPagesPerFile();
            this.mNumberOfPages.set(aNumberOfPages);
        } else {
            this.clear();
        }
    }

    @Override
    public final int getID() {
        return this.mID;
    }

    @Override
    public final int getPageSize() {
        return this.getManager().getPageSize();
    }

    @Override
    public final PageManager getManager() {
        return this.mManager;
    }

    protected final long getPageID(int thePageNumber) {
        return this.mID * this.mManager.getMaxNumberPagesPerFile() + thePageNumber;
    }

    protected final long getPosition(int thePageNumber) {
        return (long)thePageNumber * (long)this.getPageSize() + 8L;
    }

    @Override
    public final int getNumberOfPages() {
        return Math.min(this.mNumberOfPages.get(), this.mManager.getMaxNumberPagesPerFile());
    }

    @Override
    public final IOFile getFile() {
        return this.mFile;
    }

    @Override
    public Page getPage(int thePageNumber) throws IOException {
        if (thePageNumber >= this.getNumberOfPages()) {
            throw new PageNotFoundException(this.getPageID(thePageNumber));
        }
        return this.createPage(thePageNumber);
    }

    protected abstract Page createPage(int var1) throws IOException;

    @Override
    public Page newPage() throws IOException {
        int pageID = this.mNumberOfPages.getAndIncrement();
        if (pageID >= this.mManager.getMaxNumberPagesPerFile()) {
            this.mNumberOfPages.set(this.mManager.getMaxNumberPagesPerFile());
            return null;
        }
        return this.createPage(pageID);
    }

    protected void writePageCount() throws IOException {
        if (this.mFile.mode() != IOFile.Mode.READ_ONLY) {
            this.mFile.writeInt(91901190, 0L);
            this.mFile.writeInt(this.getNumberOfPages(), 4L);
        }
    }

    @Override
    public void clear() throws IOException {
        this.mNumberOfPages.set(0);
        this.writePageCount();
    }

    @Override
    public boolean repair(int theMaxPage) throws IOException {
        int maxPageCount = theMaxPage + 1;
        if (this.mNumberOfPages.get() < maxPageCount) {
            this.mNumberOfPages.set(maxPageCount);
            this.writePageCount();
            return true;
        }
        return false;
    }

    public String toString() {
        return this.mFile.toString();
    }
}

