/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.impl;

import com.complexible.common.io.ByteReader;
import com.google.common.primitives.Shorts;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public abstract class AbstractByteReader
implements ByteReader {
    @Override
    public int read(byte[] theData) throws IOException {
        for (int i = 0; i < theData.length; ++i) {
            theData[i] = this.readByte();
        }
        return theData.length;
    }

    @Override
    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    @Override
    public int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    @Override
    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readVLong() throws IOException {
        byte b = this.readByte();
        long i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= ((long)b & 0x7FL) << shift;
            shift += 7;
        }
        return i;
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readString() throws IOException {
        int length = this.readInt();
        byte[] bytes = new byte[length];
        int sizeRead = this.read(bytes);
        if (sizeRead != length) {
            throw new IOException(String.format("Buffer underflow reading a string, attempted to read %d but read %d", length, sizeRead));
        }
        return new String(bytes, 0, length, StandardCharsets.UTF_8);
    }

    @Override
    public short readShort() throws IOException {
        byte[] bytes = new byte[2];
        if (this.read(bytes) != bytes.length) {
            throw new IOException("Buffer underflow reading a short");
        }
        return Shorts.fromByteArray((byte[])bytes);
    }
}

