/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.disk;

import com.complexible.common.io.Directory;
import com.complexible.common.io.IOFile;
import com.complexible.common.io.impl.AbstractFile;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public abstract class DiskFile
extends AbstractFile {
    protected final FileChannel mChannel;

    public DiskFile(Path theFile, IOFile.Mode theMode, Directory theDir) throws IOException {
        super(theFile.getFileName().toString(), theMode, theDir);
        if (theMode == IOFile.Mode.READ_ONLY && !Files.exists(theFile, new LinkOption[0])) {
            throw new IllegalArgumentException("Doesn't make sense to open a non-existent DiskFile " + String.valueOf(theFile) + " for read-only operations");
        }
        this.mChannel = FileChannel.open(theFile, theMode.openOptions());
        this.mChannel.position(0L);
    }

    public FileChannel getChannel() {
        return this.mChannel;
    }

    @Override
    public void close() throws IOException {
        this.mChannel.close();
    }

    @Override
    public long length() throws IOException {
        return this.mChannel.size();
    }

    public static interface Factory {
        public DiskFile create(Path var1, IOFile.Mode var2, Directory var3) throws IOException;
    }
}

