/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.disk;

import com.complexible.common.io.Directory;
import com.complexible.common.io.IOFile;
import com.complexible.common.io.disk.DiskFile;
import com.complexible.common.nio.ByteBuffers;
import com.complexible.common.nio.Channels2;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;

public class ChannelFile
extends DiskFile {
    public ChannelFile(Path theFile, IOFile.Mode theMode, Directory theDir) throws IOException {
        super(theFile, theMode, theDir);
    }

    @Override
    public long getPosition() throws IOException {
        return this.mChannel.position();
    }

    @Override
    public byte readByte(long thePosition) throws IOException {
        ByteBuffer buffer = this.readInternal(thePosition, 1);
        return buffer.get(0);
    }

    @Override
    public byte readByte() throws IOException {
        ByteBuffer buffer = this.readInternal(1);
        return buffer.get(0);
    }

    @Override
    public int read(byte[] theData) throws IOException {
        ByteBuffer buffer = ByteBuffers.wrap(theData, ByteOrder.BIG_ENDIAN);
        return this.mChannel.read(buffer);
    }

    @Override
    public int read(byte[] theData, int offset, int size, long thePosition) throws IOException {
        ByteBuffer buf = ByteBuffers.wrap(theData, offset, size, ByteOrder.BIG_ENDIAN);
        return this.mChannel.read(buf, thePosition);
    }

    @Override
    public int read(byte[] theData, long thePosition) throws IOException {
        ByteBuffer buffer = ByteBuffers.wrap(theData, ByteOrder.BIG_ENDIAN);
        return this.mChannel.read(buffer, thePosition);
    }

    @Override
    public int readInt() throws IOException {
        ByteBuffer buffer = this.readInternal(4);
        return buffer.getInt(0);
    }

    @Override
    public int readInt(long thePosition) throws IOException {
        ByteBuffer buffer = this.readInternal(thePosition, 4);
        return buffer.getInt(0);
    }

    @Override
    public long readLong() throws IOException {
        ByteBuffer buffer = this.readInternal(8);
        return buffer.getLong(0);
    }

    @Override
    public long readLong(long thePosition) throws IOException {
        ByteBuffer buffer = this.readInternal(thePosition, 8);
        return buffer.getLong(0);
    }

    private ByteBuffer readInternal(long thePosition, int theBytesToRead) throws IOException {
        ByteBuffer buffer = ByteBuffers.allocate(theBytesToRead, ByteOrder.BIG_ENDIAN);
        int bytesRead = this.mChannel.read(buffer, thePosition);
        if (bytesRead != theBytesToRead) {
            throw new IOException("Read error: " + bytesRead + " != " + theBytesToRead);
        }
        return buffer;
    }

    private ByteBuffer readInternal(int theBytesToRead) throws IOException {
        ByteBuffer buffer = ByteBuffers.allocate(theBytesToRead, ByteOrder.BIG_ENDIAN);
        int bytesRead = this.mChannel.read(buffer);
        if (bytesRead != theBytesToRead) {
            throw new IOException("Read error: " + bytesRead + " != " + theBytesToRead);
        }
        return buffer;
    }

    @Override
    public void setPosition(long thePosition) throws IOException {
        this.mChannel.position(thePosition);
    }

    @Override
    public void writeByte(byte theValue, long thePosition) throws IOException {
        ByteBuffer buffer = ByteBuffers.allocate(1, ByteOrder.BIG_ENDIAN);
        buffer.put(0, theValue);
        this.writeInternal(buffer, thePosition);
    }

    @Override
    public void writeByte(byte theValue) throws IOException {
        ByteBuffer buffer = ByteBuffers.allocate(1, ByteOrder.BIG_ENDIAN);
        buffer.put(0, theValue);
        this.writeInternal(buffer);
    }

    @Override
    public void writeInt(int theValue) throws IOException {
        ByteBuffer buffer = ByteBuffers.allocate(4, ByteOrder.BIG_ENDIAN);
        buffer.putInt(0, theValue);
        this.writeInternal(buffer);
    }

    @Override
    public void writeInt(int theValue, long thePosition) throws IOException {
        ByteBuffer buffer = ByteBuffers.allocate(4, ByteOrder.BIG_ENDIAN);
        buffer.putInt(0, theValue);
        this.writeInternal(buffer, thePosition);
    }

    @Override
    public void writeLong(long theValue) throws IOException {
        ByteBuffer buffer = ByteBuffers.allocate(8, ByteOrder.BIG_ENDIAN);
        buffer.putLong(0, theValue);
        this.writeInternal(buffer);
    }

    @Override
    public void writeChar(char theChar) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.putChar(0, theChar);
        this.writeInternal(buffer);
    }

    @Override
    public void writeBuffer(long[] theData, int theOffset, int theLength) throws IOException {
        throw new UnsupportedOperationException("");
    }

    @Override
    public void writeLong(long theValue, long thePosition) throws IOException {
        ByteBuffer buffer = ByteBuffers.allocate(8, ByteOrder.BIG_ENDIAN);
        buffer.putLong(0, theValue);
        this.writeInternal(buffer, thePosition);
    }

    @Override
    public void persist() throws IOException {
        this.mChannel.force(false);
    }

    @Override
    public void write(byte[] theData) throws IOException {
        this.writeInternal(ByteBuffers.wrap(theData, ByteOrder.BIG_ENDIAN));
    }

    @Override
    public void write(byte[] theData, long thePosition) throws IOException {
        this.writeInternal(ByteBuffers.wrap(theData, ByteOrder.BIG_ENDIAN), thePosition);
    }

    @Override
    public void write(byte[] theData, int theOffset, int theLength) throws IOException {
        this.writeInternal(ByteBuffers.wrap(theData, theOffset, theLength, ByteOrder.BIG_ENDIAN));
    }

    @Override
    public void write(byte[] theData, long thePosition, int theOffset, int theLength) throws IOException {
        this.writeInternal(ByteBuffers.wrap(theData, theOffset, theLength, ByteOrder.BIG_ENDIAN), thePosition);
    }

    private void writeInternal(ByteBuffer theData, long thePosition) throws IOException {
        Channels2.writeFullyAtPosition(this.mChannel, theData, thePosition);
    }

    private void writeInternal(ByteBuffer theData) throws IOException {
        Channels2.writeFully(this.mChannel, theData);
    }

    public static class Factory
    implements DiskFile.Factory {
        @Override
        public ChannelFile create(Path theFile, IOFile.Mode theMode, Directory theDir) throws IOException {
            return new ChannelFile(theFile, theMode, theDir);
        }

        public String toString() {
            return ChannelFile.class.getSimpleName() + "Factory";
        }
    }
}

