/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io.block;

import com.complexible.common.io.block.BlockSpec;
import com.complexible.common.io.block.BlockWriter;
import java.io.Writer;

public class TextBlockWriter
extends BlockWriter {
    private int column = 0;

    public TextBlockWriter(Writer out) {
        super(out, " ");
    }

    @Override
    protected void startNewLine() {
        TextBlock currentBlock = (TextBlock)this.currentBlock();
        if (currentBlock != null) {
            this.printSpace(currentBlock.indent);
        }
    }

    @Override
    public void println() {
        super.println();
        this.column = 0;
    }

    @Override
    public void write(char[] buf, int off, int len) {
        super.write(buf, off, len);
        this.column += len;
    }

    @Override
    public void write(int c) {
        super.write(c);
        ++this.column;
    }

    @Override
    public void write(String s, int off, int len) {
        super.write(s, off, len);
        this.column += len;
    }

    @Override
    protected BlockWriter.Block createBlock(BlockSpec spec) {
        return new TextBlock(spec);
    }

    private class TextBlock
    extends BlockWriter.Block {
        private int indent;

        public TextBlock(BlockSpec spec) {
            super(spec);
        }

        @Override
        protected void afterBegin() {
            this.indent = TextBlockWriter.this.column;
        }
    }
}

