/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class TailInputStream
extends FilterInputStream {
    private final long sleepMS;
    private Callable<Boolean> mEofCallback;

    public TailInputStream(InputStream in) {
        this(in, 500L, TimeUnit.MILLISECONDS, null);
    }

    public TailInputStream(InputStream in, long sleepTime, TimeUnit sleepTimeUnit) {
        this(in, sleepTime, sleepTimeUnit, null);
    }

    public TailInputStream(InputStream in, long sleepTime, TimeUnit sleepTimeUnit, Callable<Boolean> eofCallback) {
        super(in);
        this.sleepMS = sleepTimeUnit.toMillis(sleepTime);
        this.mEofCallback = eofCallback;
    }

    private void waitForInput() throws IOException {
        try {
            while (this.in.available() < 1) {
                Thread.sleep(this.sleepMS);
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void handleEofCallback() throws IOException {
        if (this.mEofCallback != null) {
            try {
                Boolean callAgain = this.mEofCallback.call();
                if (!callAgain.booleanValue()) {
                    this.mEofCallback = null;
                }
            }
            catch (Exception aEx) {
                throw new IOException(aEx);
            }
        }
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            return b;
        }
        this.handleEofCallback();
        this.waitForInput();
        return this.in.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        int b = this.in.read(buffer, offset, count);
        if (b != -1) {
            return b;
        }
        this.handleEofCallback();
        this.waitForInput();
        return this.in.read(buffer, offset, count);
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

