/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.complexible.common.io.ByteOutput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public interface StringIO {
    public static final StringIO INSTANCE = new ModifiedUTF();
    public static final int MAX_UNSIGNED_SHORT = 65535;

    public void write(String var1, DataOutput var2) throws IOException;

    public void writeLongString(String var1, DataOutput var2) throws IOException;

    default public String read(ByteBuffer in) throws IOException {
        return this.read(in, Short.toUnsignedInt(in.getShort()));
    }

    default public String readLongString(ByteBuffer in) throws IOException {
        return this.read(in, in.getInt());
    }

    public String read(ByteBuffer var1, int var2) throws IOException;

    public static final class ModifiedUTF
    implements StringIO {
        final int FAST_PATH_LIMIT = 1024;
        private static final char repl = '\ufffd';

        @Override
        public void write(String s, DataOutput out) throws IOException {
            this.write(s, out, false);
        }

        @Override
        public void writeLongString(String s, DataOutput out) throws IOException {
            this.write(s, out, true);
        }

        void write(String s, DataOutput out, boolean writeLong) throws IOException {
            int strLength = s.length();
            byte[] utf8Output = null;
            if (strLength <= 1024 && strLength != (utf8Output = s.getBytes(StandardCharsets.UTF_8)).length) {
                utf8Output = null;
            }
            boolean isAscii = utf8Output != null;
            int utfLength = isAscii ? strLength : LegacyModifiedUTF.utfLength(s);
            int totalLength = utfLength + (writeLong ? 4 : 2);
            assert (!isAscii || LegacyModifiedUTF.utfLength(s) == strLength) : "invalid assumption about ASCII string length";
            if (!writeLong && utfLength > 65535) {
                throw new UTFDataFormatException("UTF encoding exceeds 65535 bytes: " + utfLength);
            }
            if (out instanceof ByteOutput) {
                ByteOutput directOut = (ByteOutput)((Object)out);
                directOut.ensureCapacity(directOut.length + totalLength);
            }
            if (writeLong) {
                out.writeInt(utfLength);
            } else {
                out.writeShort(utfLength);
            }
            if (utf8Output != null) {
                out.write(utf8Output, 0, utf8Output.length);
            } else {
                LegacyModifiedUTF.encodeUtf(s, out, strLength);
            }
        }

        @Override
        public String read(ByteBuffer in, int utfLength) throws IOException {
            int pos = in.position();
            if (utfLength <= 1024) {
                String ret;
                if (in.hasArray()) {
                    ret = new String(in.array(), in.position() + in.arrayOffset(), utfLength, StandardCharsets.UTF_8);
                    in.position(pos + utfLength);
                } else {
                    byte[] buf = new byte[utfLength];
                    in.get(buf);
                    ret = new String(buf, StandardCharsets.UTF_8);
                }
                if (ret.indexOf(65533) < 0) {
                    return ret;
                }
            }
            in.position(pos);
            return LegacyModifiedUTF.decodeUtf(in, utfLength);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String decodeCharsetDecoder(ByteBuffer in, int utfLength) {
            int limit = in.limit();
            int pos = in.position();
            try {
                in.limit(pos + utfLength);
                CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT);
                CharBuffer charBuf = decoder.decode(in);
                String string = charBuf.toString();
                return string;
            }
            catch (CharacterCodingException characterCodingException) {
            }
            finally {
                in.limit(limit);
            }
            return null;
        }
    }

    public static final class LegacyModifiedUTF
    implements StringIO {
        @Override
        public void write(String s, DataOutput out) throws IOException {
            this.write(s, out, false);
        }

        @Override
        public void writeLongString(String s, DataOutput out) throws IOException {
            this.write(s, out, true);
        }

        @Override
        public String read(ByteBuffer in, int utfLength) throws IOException {
            return LegacyModifiedUTF.decodeUtf(in, utfLength);
        }

        void write(String s, DataOutput out, boolean writeLong) throws IOException {
            int strLength = s.length();
            int utfLength = LegacyModifiedUTF.utfLength(s);
            int totalLength = utfLength + (writeLong ? 4 : 2);
            if (!writeLong && utfLength > 65535) {
                throw new UTFDataFormatException("UTF encoding exceeds 65535 bytes: " + utfLength);
            }
            if (out instanceof ByteOutput) {
                ByteOutput directOut = (ByteOutput)((Object)out);
                directOut.ensureCapacity(directOut.length + totalLength);
            }
            if (writeLong) {
                out.writeInt(utfLength);
            } else {
                out.writeShort(utfLength);
            }
            LegacyModifiedUTF.encodeUtf(s, out, strLength);
        }

        private static int utfLength(String s) throws UTFDataFormatException {
            long utfLength = 0L;
            int length = s.length();
            for (int i = 0; i < length; ++i) {
                char c = s.charAt(i);
                if (c > '\u0000' && c <= '\u007f') {
                    ++utfLength;
                    continue;
                }
                if (c > '\u07ff') {
                    utfLength += 3L;
                    continue;
                }
                utfLength += 2L;
            }
            if (utfLength > Integer.MAX_VALUE) {
                throw new UTFDataFormatException("UTF encoding exceeds integer limit: " + utfLength + " bytes");
            }
            return (int)utfLength;
        }

        private static void encodeUtf(String s, DataOutput out, int strLength) throws IOException {
            for (int i = 0; i < strLength; ++i) {
                char c = s.charAt(i);
                if (c > '\u0000' && c <= '\u007f') {
                    out.writeByte((byte)c);
                    continue;
                }
                if (c > '\u07ff') {
                    out.writeByte((byte)(0xE0 | c >> 12 & 0xF));
                    out.writeByte((byte)(0x80 | c >> 6 & 0x3F));
                    out.writeByte((byte)(0x80 | c >> 0 & 0x3F));
                    continue;
                }
                out.writeByte((byte)(0xC0 | c >> 6 & 0x1F));
                out.writeByte((byte)(0x80 | c >> 0 & 0x3F));
            }
        }

        private static String decodeUtf(ByteBuffer in, int utfLength) throws UTFDataFormatException {
            byte[] buf;
            char[] out = new char[utfLength];
            int count = 0;
            if (in.hasArray()) {
                buf = in.array();
                count = in.position() + in.arrayOffset();
                in.position(count + utfLength);
                utfLength += count;
            } else {
                buf = new byte[utfLength];
                in.get(buf);
            }
            int s = 0;
            while (count < utfLength) {
                byte b;
                if ((out[s] = (char)buf[count++]) < '\u0080') {
                    ++s;
                    continue;
                }
                char a = out[s];
                if ((a & 0xE0) == 192) {
                    if (count >= utfLength) {
                        throw new UTFDataFormatException("Offset: " + count);
                    }
                    if (((b = buf[count++]) & 0xC0) != 128) {
                        throw new UTFDataFormatException("Offset: " + count);
                    }
                    out[s++] = (char)((a & 0x1F) << 6 | b & 0x3F);
                    continue;
                }
                if ((a & 0xF0) == 224) {
                    if (count + 1 >= utfLength) {
                        throw new UTFDataFormatException("Offset: " + count);
                    }
                    b = buf[count++];
                    byte c = buf[count++];
                    if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                        throw new UTFDataFormatException("Offset: " + count);
                    }
                    out[s++] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                    continue;
                }
                throw new UTFDataFormatException("Offset: " + count);
            }
            return new String(out, 0, s);
        }
    }

    public static final class StandardUTF
    implements StringIO {
        @Override
        public void write(String s, DataOutput out) throws IOException {
            byte[] utf8Output = s.getBytes(StandardCharsets.UTF_8);
            out.writeShort(utf8Output.length);
            out.write(utf8Output, 0, utf8Output.length);
        }

        @Override
        public void writeLongString(String s, DataOutput out) throws IOException {
            byte[] utf8Output = s.getBytes(StandardCharsets.UTF_8);
            out.writeInt(utf8Output.length);
            out.write(utf8Output, 0, utf8Output.length);
        }

        @Override
        public String read(ByteBuffer in, int utfLength) throws IOException {
            byte[] encodedString = new byte[utfLength];
            in.get(encodedString);
            return new String(encodedString, StandardCharsets.UTF_8);
        }
    }
}

