/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.complexible.common.io.FileRotationStrategy;
import com.google.common.base.Preconditions;
import java.nio.file.Path;

public final class SizeRotationStrategy
implements FileRotationStrategy {
    private final long mMaxSize;

    public SizeRotationStrategy(long theMaxSize) {
        Preconditions.checkArgument((theMaxSize > 0L ? 1 : 0) != 0);
        this.mMaxSize = theMaxSize;
    }

    public long getMaxSize() {
        return this.mMaxSize;
    }

    @Override
    public boolean needsRotation(Path theFile, long fileLength) {
        return fileLength > this.mMaxSize;
    }
}

