/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.complexible.common.io.ByteReader;
import com.complexible.common.io.ByteWriter;
import com.complexible.common.io.Directory;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;

public interface IOFile
extends ByteReader,
ByteWriter,
Closeable {
    public String getName();

    public Mode mode();

    public Directory getDirectory();

    public int read(byte[] var1, long var2) throws IOException;

    public int read(byte[] var1, int var2, int var3, long var4) throws IOException;

    public byte readByte(long var1) throws IOException;

    public int readInt(long var1) throws IOException;

    public int readVInt(long var1) throws IOException;

    public long readLong(long var1) throws IOException;

    public long readVLong(long var1) throws IOException;

    public double readDouble(long var1) throws IOException;

    public float readFloat(long var1) throws IOException;

    public String readString(long var1) throws IOException;

    public void write(byte[] var1, long var2) throws IOException;

    public void write(byte[] var1, long var2, int var4, int var5) throws IOException;

    public void writeByte(byte var1, long var2) throws IOException;

    public void writeInt(int var1, long var2) throws IOException;

    public void writeVInt(int var1, long var2) throws IOException;

    public void writeLong(long var1, long var3) throws IOException;

    public void writeVLong(long var1, long var3) throws IOException;

    public void writeFloat(float var1, long var2) throws IOException;

    public void writeDouble(double var1, long var3) throws IOException;

    public void writeString(String var1, long var2) throws IOException;

    public void persist() throws IOException;

    public static enum Mode {
        READ_ONLY{

            @Override
            public OpenOption[] openOptions() {
                return new OpenOption[]{StandardOpenOption.READ};
            }

            public String toString() {
                return "r";
            }
        }
        ,
        READ_WRITE{

            @Override
            public OpenOption[] openOptions() {
                return new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            }

            public String toString() {
                return "rw";
            }
        };


        public abstract OpenOption[] openOptions();
    }
}

