/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.complexible.common.io.ByteStreams2;
import com.complexible.common.io.DataOutputFunnel;
import com.google.common.base.Charsets;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public final class DataOutputFunnels {
    private DataOutputFunnels() {
        throw new AssertionError();
    }

    public static <T extends Serializable> DataOutputFunnel<T, DataOutput> serializable() {
        return new SerializableFunnel();
    }

    private static final class SerializableFunnel<T extends Serializable>
    implements DataOutputFunnel<T, DataOutput> {
        private SerializableFunnel() {
        }

        @Override
        public void funnel(T theObj, DataOutput theTo) throws IOException {
            byte[] aBytes = ByteStreams2.toByteArray(theObj);
            theTo.writeInt(aBytes.length);
            theTo.write(aBytes);
        }
    }

    public static enum Primitives implements DataOutputFunnel<Object, DataOutput>
    {
        INT((theObj, theTo) -> theTo.writeInt((Integer)theObj)),
        LONG((theObj, theTo) -> theTo.writeLong((Long)theObj)),
        FLOAT((theObj, theTo) -> theTo.writeFloat(((Float)theObj).floatValue())),
        STRING((theObj, theTo) -> {
            String aObj = (String)theObj;
            byte[] aBytes = aObj.getBytes(Charsets.UTF_8);
            theTo.writeInt(aBytes.length);
            theTo.write(aBytes);
        });

        private final DataOutputFunnel<Object, DataOutput> mOutputWriter;

        private Primitives(DataOutputFunnel<Object, DataOutput> theOutputWriter) {
            this.mOutputWriter = theOutputWriter;
        }

        @Override
        public void funnel(Object theObj, DataOutput theTo) throws IOException {
            this.mOutputWriter.funnel(theObj, theTo);
        }
    }
}

