/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.google.common.io.ByteSource;
import com.google.common.primitives.Ints;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class ByteSourceOutputStream
extends OutputStream {
    private final int fileThreshold;
    private final ByteSource source;
    private final boolean deleteOnClose;
    private OutputStream out;
    private MemoryOutput memory;
    private Path file;

    public synchronized Path getFile() {
        return this.file;
    }

    private ByteSourceOutputStream(long fileThreshold, boolean deleteOnClose) {
        this.fileThreshold = Ints.saturatedCast((long)fileThreshold);
        this.deleteOnClose = deleteOnClose;
        this.memory = new MemoryOutput();
        this.out = this.memory;
        this.source = new ByteSource(){

            public InputStream openStream() throws IOException {
                if (ByteSourceOutputStream.this.file != null) {
                    if (ByteSourceOutputStream.this.out != null) {
                        ByteSourceOutputStream.this.flush();
                    }
                    return Files.newInputStream(ByteSourceOutputStream.this.file, new OpenOption[0]);
                }
                return new ByteArrayInputStream(ByteSourceOutputStream.this.memory.getBuffer(), 0, ByteSourceOutputStream.this.memory.getCount());
            }

            public long size() throws IOException {
                if (ByteSourceOutputStream.this.file != null) {
                    return Files.size(ByteSourceOutputStream.this.file);
                }
                return ByteSourceOutputStream.this.memory.getCount();
            }
        };
    }

    public ByteSource asByteSource() throws IOException {
        return this.source;
    }

    public synchronized void reset() throws IOException {
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        finally {
            if (this.memory == null) {
                this.memory = new MemoryOutput();
            } else {
                this.memory.reset();
            }
            this.out = this.memory;
            if (this.file != null) {
                this.deleteFile();
            }
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.update(1);
        this.out.write(b);
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.update(len);
        this.out.write(b, off, len);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.deleteOnClose) {
            if (this.memory != null) {
                this.memory.dispose();
            } else {
                this.deleteFile();
            }
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    private void deleteFile() throws IOException {
        if (this.file != null) {
            Path deleteMe = this.file;
            this.file = null;
            Files.delete(deleteMe);
        }
    }

    private void update(int len) throws IOException {
        if (this.file == null && this.memory.getCount() + len > this.fileThreshold) {
            Path temp = Files.createTempFile("ByteSourceOutputStream", null, new FileAttribute[0]);
            BufferedOutputStream transfer = new BufferedOutputStream(Files.newOutputStream(temp, new OpenOption[0]));
            ((OutputStream)transfer).write(this.memory.getBuffer(), 0, this.memory.getCount());
            ((OutputStream)transfer).flush();
            this.out = transfer;
            this.file = temp;
            this.memory = null;
        }
    }

    public static ByteSourceOutputStream deleteOnClose(long fileThreshold) {
        return new ByteSourceOutputStream(fileThreshold, true);
    }

    public static ByteSourceOutputStream create(long fileThreshold) {
        return new ByteSourceOutputStream(fileThreshold, false);
    }

    private static class MemoryOutput
    extends ByteArrayOutputStream {
        private MemoryOutput() {
        }

        byte[] getBuffer() {
            return this.buf;
        }

        int getCount() {
            return this.count;
        }

        public void dispose() {
            this.buf = null;
        }
    }
}

