/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.google.common.io.ByteSink;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public final class ByteSinks {
    private ByteSinks() {
        throw new AssertionError();
    }

    public static ByteSink gzip(ByteSink theSink) {
        return new GZIPByteSink(theSink);
    }

    private static final class GZIPByteSink
    extends ByteSink {
        private final ByteSink mSink;

        private GZIPByteSink(ByteSink theSink) {
            this.mSink = theSink;
        }

        public static GZIPByteSink create(ByteSink theByteSink) {
            if (theByteSink instanceof GZIPByteSink) {
                return (GZIPByteSink)theByteSink;
            }
            return new GZIPByteSink(theByteSink);
        }

        public OutputStream openStream() throws IOException {
            return new GZIPOutputStream(this.mSink.openStream());
        }
    }
}

