/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import com.complexible.common.io.ByteReader;
import com.complexible.common.io.impl.AbstractByteReader;
import com.complexible.common.io.mem.MemoryByteReader;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class ByteReaders {
    private static final ByteReader EMPTY_READER = new MemoryByteReader(new byte[0]);

    private ByteReaders() {
        throw new AssertionError();
    }

    public static byte[] toByteArray(ByteReader theReader) throws IOException {
        byte[] aArray = new byte[Ints.checkedCast((long)(theReader.length() - theReader.getPosition()))];
        int len = theReader.read(aArray);
        assert (len == aArray.length);
        return aArray;
    }

    public static ByteReader empty() {
        return EMPTY_READER;
    }

    public static boolean isConsumed(ByteReader theReader) throws IOException {
        return theReader.getPosition() >= theReader.length();
    }

    public static ByteReader of(InputStream theInputStream) {
        return new InputStreamByteReader(theInputStream);
    }

    public static ByteReader of(InputStream theInputStream, long theLength) {
        return new InputStreamByteReader(theInputStream, theLength);
    }

    private static class InputStreamByteReader
    extends AbstractByteReader {
        private static final long UNKNOWN = -1L;
        private final InputStream mStream;
        private long mPosition = 0L;
        private final long mLength;

        private InputStreamByteReader(InputStream theStream) {
            this(theStream, -1L);
        }

        private InputStreamByteReader(InputStream theStream, long theLength) {
            Preconditions.checkNotNull((Object)theStream);
            this.mStream = theStream;
            this.mLength = theLength;
        }

        @Override
        public long getPosition() throws IOException {
            return this.mPosition;
        }

        @Override
        public long length() throws IOException {
            if (this.mLength == -1L) {
                throw new UnsupportedOperationException();
            }
            return this.mLength;
        }

        @Override
        public void setPosition(long thePosition) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte readByte() throws IOException {
            int b = this.mStream.read();
            if (b == -1) {
                throw new EOFException();
            }
            ++this.mPosition;
            return (byte)b;
        }

        @Override
        public int read(byte[] theData) throws IOException {
            int offset = 0;
            int remaining = theData.length;
            if (remaining == 0) {
                return 0;
            }
            while (remaining > 0) {
                int bytesRead = this.mStream.read(theData, offset, remaining);
                if (bytesRead == -1) {
                    throw new EOFException();
                }
                offset += bytesRead;
                remaining -= bytesRead;
            }
            this.mPosition += (long)theData.length;
            return theData.length;
        }
    }
}

