/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.io;

import java.io.IOException;

public interface ByteReader {
    public long length() throws IOException;

    public long getPosition() throws IOException;

    public void setPosition(long var1) throws IOException;

    public int read(byte[] var1) throws IOException;

    default public int read(byte[] theData, int offset, int length) throws IOException {
        throw new IllegalStateException("Not supported");
    }

    default public int readNative(long address, int length) throws IOException {
        throw new IllegalStateException("Not supported");
    }

    default public long readBuffer(long[] theBuffer, long theOffset, long theLength) throws IOException {
        int len = (int)theLength / 8;
        int offset = (int)theOffset / 8;
        while (len-- > 0) {
            theBuffer[offset++] = this.readLong();
        }
        return theLength;
    }

    default public long readBuffer(char[] theBuffer, long theOffset, long theLength) {
        throw new UnsupportedOperationException("Not supported");
    }

    public byte readByte() throws IOException;

    public int readInt() throws IOException;

    default public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    public int readVInt() throws IOException;

    public long readLong() throws IOException;

    public long readVLong() throws IOException;

    public double readDouble() throws IOException;

    public float readFloat() throws IOException;

    public String readString() throws IOException;

    public short readShort() throws IOException;
}

