/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.hppc;

import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntObjectAssociativeContainer;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectIntHashMap;
import com.carrotsearch.hppc.ObjectIntMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.predicates.IntObjectPredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.IntObjectProcedure;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;

public final class IntObjectBiMap<T>
implements IntObjectMap<T> {
    private final IntObjectMap<T> mMap;
    private final ObjectIntMap<T> mInverse;

    public IntObjectBiMap() {
        this((IntObjectMap<T>)new IntObjectHashMap(), (ObjectIntMap<T>)new ObjectIntHashMap());
    }

    public IntObjectBiMap(IntObjectBiMap<T> theMap) {
        this((IntObjectMap<T>)new IntObjectHashMap(theMap.mMap), (ObjectIntMap<T>)new ObjectIntHashMap(theMap.mInverse));
    }

    public IntObjectBiMap(IntObjectMap<T> theMap, ObjectIntMap<T> theInverse) {
        this.mMap = theMap;
        this.mInverse = theInverse;
    }

    public ObjectIntMap<T> inverse() {
        return this.mInverse;
    }

    public void clear() {
        this.mMap.clear();
        this.mInverse.clear();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntObjectBiMap) {
            IntObjectBiMap other = (IntObjectBiMap)obj;
            return this.mMap.equals(other.mMap);
        }
        return false;
    }

    public T get(int key) {
        return (T)this.mMap.get(key);
    }

    public T getOrDefault(int key, T defaultValue) {
        return (T)this.mMap.getOrDefault(key, defaultValue);
    }

    public int hashCode() {
        return this.mMap.hashCode();
    }

    public boolean indexExists(int index) {
        return this.mMap.indexExists(index);
    }

    public T indexGet(int index) {
        return (T)this.mMap.indexGet(index);
    }

    public void indexInsert(int index, int key, T value) {
        this.mMap.indexInsert(index, key, value);
    }

    public int indexOf(int key) {
        return this.mMap.indexOf(key);
    }

    public T indexReplace(int index, T newValue) {
        return (T)this.mMap.indexReplace(index, newValue);
    }

    public T put(int key, T value) {
        this.mInverse.put(value, key);
        return (T)this.mMap.put(key, value);
    }

    public int putAll(IntObjectAssociativeContainer<? extends T> container) {
        container.forEach((key, value) -> this.mInverse.put(value, key));
        return this.mMap.putAll(container);
    }

    public int putAll(Iterable<? extends IntObjectCursor<? extends T>> iterable) {
        iterable.forEach((? super T cursor) -> this.mInverse.put(cursor.value, cursor.key));
        return this.mMap.putAll(iterable);
    }

    public void release() {
        this.mInverse.release();
        this.mMap.release();
    }

    public T remove(int key) {
        Object aValue = this.mMap.remove(key);
        this.mInverse.remove(aValue);
        return (T)aValue;
    }

    public String visualizeKeyDistribution(int characters) {
        return this.mMap.visualizeKeyDistribution(characters);
    }

    public boolean containsKey(int key) {
        return this.mMap.containsKey(key);
    }

    public <T1 extends IntObjectPredicate<? super T>> T1 forEach(T1 predicate) {
        return (T1)this.mMap.forEach(predicate);
    }

    public <T1 extends IntObjectProcedure<? super T>> T1 forEach(T1 procedure) {
        return (T1)this.mMap.forEach(procedure);
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public Iterator<IntObjectCursor<T>> iterator() {
        return this.mMap.iterator();
    }

    public IntCollection keys() {
        return this.mMap.keys();
    }

    public int removeAll(IntContainer container) {
        int removed = 0;
        Iterator aIter = container.iterator();
        while (aIter.hasNext()) {
            T aValue = this.remove(((IntCursor)aIter.next()).value);
            if (aValue == null) continue;
            ++removed;
        }
        return removed;
    }

    public int removeAll(IntObjectPredicate<? super T> predicate) {
        int removed = 0;
        Iterator aIter = this.keys().iterator();
        while (aIter.hasNext()) {
            int aKey = ((IntCursor)aIter.next()).value;
            T aValue = this.get(aKey);
            if (!predicate.apply(aKey, aValue)) continue;
            ++removed;
            this.remove(aKey);
        }
        return removed;
    }

    public int removeAll(IntPredicate predicate) {
        int removed = 0;
        Iterator aIter = this.keys().iterator();
        while (aIter.hasNext()) {
            int aKey = ((IntCursor)aIter.next()).value;
            if (!predicate.apply(aKey)) continue;
            ++removed;
            this.remove(aKey);
        }
        return removed;
    }

    public int size() {
        return this.mMap.size();
    }

    public ObjectContainer<T> values() {
        return this.mMap.values();
    }

    public void forEach(Consumer<? super IntObjectCursor<T>> action) {
        this.mMap.forEach(action);
    }

    public Spliterator<IntObjectCursor<T>> spliterator() {
        return this.mMap.spliterator();
    }
}

